/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.controllers.PartitionManager;
import io.confluent.kafkarest.entities.Partition;
import io.confluent.kafkarest.entities.v3.ListPartitionOffsetsResponse;
import io.confluent.kafkarest.entities.v3.PartitionWithOffsetsData;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@Path(value="/v3/clusters/{clusterId}/topics/{topicName}/partitions/{partitionId}/offset")
@ResourceAccesslistFeature.ResourceName(value="api.v3.partition-offsets.*")
public class ListPartitionOffsetsAction {
    private final Provider<PartitionManager> partitionManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public ListPartitionOffsetsAction(Provider<PartitionManager> partitionManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.partitionManager = Objects.requireNonNull(partitionManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.partitions.list.offsets")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.partitions.list.offsets")
    public void listPartitionOffsets(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @PathParam(value="partitionId") Integer partitionId, @QueryParam(value="offset_type") @DefaultValue(value="earliest_and_latest") String offsetType) {
        if (!offsetType.equals("earliest_and_latest")) {
            throw new BadRequestException("offset_type:" + offsetType + " is invalid");
        }
        CompletionStage response = ((CompletableFuture)((PartitionManager)this.partitionManager.get()).getPartition(clusterId, topicName, partitionId).thenApply(partition -> (Partition)partition.orElseThrow(Errors::partitionNotFoundException))).thenApply(partition -> ListPartitionOffsetsResponse.create(this.toPartitionWithOffsetsData((Partition)partition, offsetType)));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    private PartitionWithOffsetsData toPartitionWithOffsetsData(Partition partition, String offsetType) {
        return ListPartitionOffsetsAction.toPartitionWithOffsetsData(this.crnFactory, this.urlFactory, partition, offsetType);
    }

    static PartitionWithOffsetsData toPartitionWithOffsetsData(CrnFactory crnFactory, UrlFactory urlFactory, Partition partition, String offsetType) {
        PartitionWithOffsetsData.Builder partitionWithOffsetsData = (PartitionWithOffsetsData.Builder)PartitionWithOffsetsData.fromPartition(partition).setMetadata(Resource.Metadata.builder().setSelf(urlFactory.create("v3", "clusters", partition.getClusterId(), "topics", partition.getTopicName(), "partitions", Integer.toString(partition.getPartitionId()), "offset")).setResourceName(crnFactory.create("kafka", partition.getClusterId(), "topic", partition.getTopicName(), "partition", Integer.toString(partition.getPartitionId()), "offset_type", offsetType)).build());
        return partitionWithOffsetsData.build();
    }
}

