/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.TopicConfigManager;
import io.confluent.kafkarest.controllers.TopicManager;
import io.confluent.kafkarest.entities.AbstractConfig;
import io.confluent.kafkarest.entities.v3.ListTopicConfigsResponse;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.entities.v3.TopicConfigDataList;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.resources.v3.TopicConfigsResource;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

@Path(value="/v3/clusters/{clusterId}/topics/-/configs")
@ResourceAccesslistFeature.ResourceName(value="api.v3.topic-configs.*")
public final class ListAllTopicsConfigsAction {
    private final Provider<TopicManager> topicManager;
    private final Provider<TopicConfigManager> topicConfigManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public ListAllTopicsConfigsAction(Provider<TopicManager> topicManager, Provider<TopicConfigManager> topicConfigManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.topicManager = Objects.requireNonNull(topicManager);
        this.topicConfigManager = Objects.requireNonNull(topicConfigManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.configs.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.topic-configs.list")
    public void listTopicConfigs(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId) {
        TopicConfigManager resolvedTopicConfigManager = (TopicConfigManager)this.topicConfigManager.get();
        CompletionStage response = ((TopicManager)this.topicManager.get()).listTopics(clusterId).thenCompose(topics -> resolvedTopicConfigManager.listTopicConfigs(clusterId, topics.stream().map(topic -> topic.getName()).collect(Collectors.toList())).thenApply(configs -> ListTopicConfigsResponse.create((TopicConfigDataList)((TopicConfigDataList.Builder)((TopicConfigDataList.Builder)TopicConfigDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", clusterId, "topics", "-", "configs")).build())).setData(configs.values().stream().flatMap(topicConfigs -> topicConfigs.stream().sorted(Comparator.comparing(AbstractConfig::getName))).map(topicConfig -> TopicConfigsResource.toTopicConfigData(topicConfig, this.crnFactory, this.urlFactory)).collect(Collectors.toList()))).build())));
        AsyncResponses.asyncResume(asyncResponse, response);
    }
}

