/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.ConsumerGroupLagSummaryManager;
import io.confluent.kafkarest.entities.ConsumerGroupLagSummary;
import io.confluent.kafkarest.entities.v3.ConsumerGroupLagSummaryData;
import io.confluent.kafkarest.entities.v3.GetConsumerGroupLagSummaryResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@Path(value="/v3/clusters/{clusterId}/consumer-groups/{consumerGroupId}/lag-summary")
@ResourceAccesslistFeature.ResourceName(value="api.v3.consumer-group-lag-summary.*")
public final class ConsumerGroupLagSummariesResource {
    private final Provider<ConsumerGroupLagSummaryManager> consumerGroupLagSummaryManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public ConsumerGroupLagSummariesResource(Provider<ConsumerGroupLagSummaryManager> consumerGroupLagSummaryManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.consumerGroupLagSummaryManager = Objects.requireNonNull(consumerGroupLagSummaryManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.consumer-group-lag-summary.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.consumer-group-lag-summary.get")
    public void getConsumerGroupLagSummary(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="consumerGroupId") String consumerGroupId) {
        CompletionStage response = ((CompletableFuture)((ConsumerGroupLagSummaryManager)this.consumerGroupLagSummaryManager.get()).getConsumerGroupLagSummary(clusterId, consumerGroupId).thenApply(groupLagSummary -> (ConsumerGroupLagSummary)groupLagSummary.orElseThrow(NotFoundException::new))).thenApply(groupLagSummary -> GetConsumerGroupLagSummaryResponse.create(this.toConsumerGroupLagSummaryData((ConsumerGroupLagSummary)groupLagSummary)));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    private ConsumerGroupLagSummaryData toConsumerGroupLagSummaryData(ConsumerGroupLagSummary groupLagSummary) {
        return ((ConsumerGroupLagSummaryData.Builder)ConsumerGroupLagSummaryData.fromConsumerGroupLagSummary(groupLagSummary).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", groupLagSummary.getClusterId(), "consumer-groups", groupLagSummary.getConsumerGroupId(), "lag-summary")).setResourceName(this.crnFactory.create("kafka", groupLagSummary.getClusterId(), "consumer-group", groupLagSummary.getConsumerGroupId(), "lag-summary", null)).build())).setMaxLagConsumer(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", groupLagSummary.getClusterId(), "consumer-groups", groupLagSummary.getConsumerGroupId(), "consumers", groupLagSummary.getMaxLagConsumerId()))).setMaxLagPartition(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", groupLagSummary.getClusterId(), "topics", groupLagSummary.getMaxLagTopicName(), "partitions", Integer.toString(groupLagSummary.getMaxLagPartitionId())))).build();
    }
}

