/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.ConsumerAssignmentManager;
import io.confluent.kafkarest.entities.ConsumerAssignment;
import io.confluent.kafkarest.entities.v3.ConsumerAssignmentData;
import io.confluent.kafkarest.entities.v3.ConsumerAssignmentDataList;
import io.confluent.kafkarest.entities.v3.GetConsumerAssignmentResponse;
import io.confluent.kafkarest.entities.v3.ListConsumerAssignmentsResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

@Path(value="/v3/clusters/{clusterId}/consumer-groups/{consumerGroupId}/consumers/{consumerId}/assignments")
@ResourceAccesslistFeature.ResourceName(value="api.v3.consumer-assignments.*")
public final class ConsumerAssignmentsResource {
    private final Provider<ConsumerAssignmentManager> consumerAssignmentManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public ConsumerAssignmentsResource(Provider<ConsumerAssignmentManager> consumerAssignmentManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.consumerAssignmentManager = Objects.requireNonNull(consumerAssignmentManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.consumer-assignments.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.consumer-assignments.list")
    public void listConsumerAssignments(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="consumerGroupId") String consumerGroupId, @PathParam(value="consumerId") String consumerId) {
        CompletionStage response = ((ConsumerAssignmentManager)this.consumerAssignmentManager.get()).listConsumerAssignments(clusterId, consumerGroupId, consumerId).thenApply(assignments -> ListConsumerAssignmentsResponse.create((ConsumerAssignmentDataList)((ConsumerAssignmentDataList.Builder)((ConsumerAssignmentDataList.Builder)ConsumerAssignmentDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", clusterId, "consumer-groups", consumerGroupId, "consumers", consumerId, "assignments")).build())).setData(assignments.stream().map(this::toConsumerAssignmentData).sorted(Comparator.comparing(ConsumerAssignmentData::getTopicName).thenComparing(ConsumerAssignmentData::getPartitionId)).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @GET
    @Path(value="/{topicName}/partitions/{partitionId}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.consumer-assignments.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.consumer-assignments.get")
    public void getConsumerAssignment(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="consumerGroupId") String consumerGroupId, @PathParam(value="consumerId") String consumerId, @PathParam(value="topicName") String topicName, @PathParam(value="partitionId") int partitionId) {
        CompletionStage response = ((CompletableFuture)((ConsumerAssignmentManager)this.consumerAssignmentManager.get()).getConsumerAssignment(clusterId, consumerGroupId, consumerId, topicName, partitionId).thenApply(assignment -> (ConsumerAssignment)assignment.orElseThrow(NotFoundException::new))).thenApply(assignment -> GetConsumerAssignmentResponse.create(this.toConsumerAssignmentData((ConsumerAssignment)assignment)));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    private ConsumerAssignmentData toConsumerAssignmentData(ConsumerAssignment assignment) {
        return ((ConsumerAssignmentData.Builder)ConsumerAssignmentData.fromConsumerAssignment(assignment).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", assignment.getClusterId(), "consumer-groups", assignment.getConsumerGroupId(), "consumers", assignment.getConsumerId(), "assignments", assignment.getTopicName(), "partitions", Integer.toString(assignment.getPartitionId()))).setResourceName(this.crnFactory.create("kafka", assignment.getClusterId(), "consumer-group", assignment.getConsumerGroupId(), "consumer", assignment.getConsumerId(), "assignment", assignment.getTopicName(), "partition", Integer.toString(assignment.getPartitionId()))).build())).setPartition(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", assignment.getClusterId(), "topics", assignment.getTopicName(), "partitions", Integer.toString(assignment.getPartitionId())))).setLag(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", assignment.getClusterId(), "consumer-groups", assignment.getConsumerGroupId(), "lags", assignment.getTopicName(), "partitions", Integer.toString(assignment.getPartitionId())))).build();
    }
}

