/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.entities.Cluster;
import io.confluent.kafkarest.entities.v3.ClusterData;
import io.confluent.kafkarest.entities.v3.ClusterDataList;
import io.confluent.kafkarest.entities.v3.GetClusterResponse;
import io.confluent.kafkarest.entities.v3.ListClustersResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

@Path(value="/v3/clusters")
@ResourceAccesslistFeature.ResourceName(value="api.v3.clusters.*")
public final class ClustersResource {
    private final Provider<ClusterManager> clusterManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public ClustersResource(Provider<ClusterManager> clusterManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.clusterManager = Objects.requireNonNull(clusterManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.clusters.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.clusters.list")
    public void listClusters(@Suspended AsyncResponse asyncResponse) {
        CompletionStage response = ((ClusterManager)this.clusterManager.get()).listClusters().thenApply(clusters -> ListClustersResponse.create((ClusterDataList)((ClusterDataList.Builder)((ClusterDataList.Builder)ClusterDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters")).build())).setData(clusters.stream().map(this::toClusterData).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @GET
    @Path(value="/{clusterId}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.clusters.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.clusters.get")
    public void getCluster(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId) {
        CompletionStage response = ((CompletableFuture)((ClusterManager)this.clusterManager.get()).getCluster(clusterId).thenApply(cluster -> (Cluster)cluster.orElseThrow(NotFoundException::new))).thenApply(cluster -> GetClusterResponse.create(this.toClusterData((Cluster)cluster)));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    private ClusterData toClusterData(Cluster cluster) {
        ClusterData.Builder clusterData = ((ClusterData.Builder)ClusterData.fromCluster(cluster).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", cluster.getClusterId())).setResourceName(this.crnFactory.create("kafka", cluster.getClusterId())).build())).setAcls(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", cluster.getClusterId(), "acls"))).setBrokers(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", cluster.getClusterId(), "brokers"))).setBrokerConfigs(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", cluster.getClusterId(), "broker-configs"))).setConsumerGroups(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", cluster.getClusterId(), "consumer-groups"))).setTopics(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", cluster.getClusterId(), "topics"))).setPartitionReassignments(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", cluster.getClusterId(), "topics", "-", "partitions", "-", "reassignment")));
        if (cluster.getController() != null) {
            clusterData.setController(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", cluster.getClusterId(), "brokers", Integer.toString(cluster.getController().getBrokerId()))));
        }
        return clusterData.build();
    }
}

