/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.controllers.ClusterConfigManager;
import io.confluent.kafkarest.entities.ClusterConfig;
import io.confluent.kafkarest.entities.v3.AlterClusterConfigBatchRequest;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

@Path(value="/v3/clusters/{clusterId}/{config_type}-configs:alter")
@ResourceAccesslistFeature.ResourceName(value="api.v3.cluster-configs.*")
public final class AlterClusterConfigBatchAction {
    private final Provider<ClusterConfigManager> clusterConfigManager;

    @Inject
    public AlterClusterConfigBatchAction(Provider<ClusterConfigManager> clusterConfigManager) {
        this.clusterConfigManager = Objects.requireNonNull(clusterConfigManager);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.clusters.configs.alter")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.cluster-configs.alter")
    public void alterClusterConfigBatch(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="config_type") ClusterConfig.Type configType, @Valid AlterClusterConfigBatchRequest request) {
        if (request == null) {
            throw Errors.invalidPayloadException("Null input provided. Data is required.");
        }
        CompletableFuture<Void> response = ((ClusterConfigManager)this.clusterConfigManager.get()).alterClusterConfigs(clusterId, configType, request.getValue().toAlterConfigCommands());
        AsyncResponses.AsyncResponseBuilder.from(Response.status((Response.Status)Response.Status.NO_CONTENT)).entity(response).asyncResume(asyncResponse);
    }
}

