/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.exceptions;

import jakarta.ws.rs.core.Response;
import java.util.Objects;

public class StatusCodeException
extends RuntimeException {
    private final Response.Status status;
    private final int code;
    private final String title;
    private final String detail;

    public static StatusCodeException create(Response.Status status, String title, String detail) {
        return new StatusCodeException(status, title, detail);
    }

    public StatusCodeException(Response.Status status, String title, String detail) {
        this(status, status.getStatusCode(), title, detail);
    }

    public static StatusCodeException create(Response.Status status, String title, String detail, Throwable cause) {
        return new StatusCodeException(status, title, detail, cause);
    }

    StatusCodeException(Response.Status status, String title, String detail, Throwable cause) {
        this(status, status.getStatusCode(), title, detail, cause);
    }

    StatusCodeException(Response.Status status, Integer code, String title, String detail) {
        super(detail);
        this.status = Objects.requireNonNull(status);
        this.code = code;
        this.title = Objects.requireNonNull(title);
        this.detail = Objects.requireNonNull(detail);
    }

    StatusCodeException(Response.Status status, int code, String title, String detail, Throwable cause) {
        super(detail, cause);
        this.status = Objects.requireNonNull(status);
        this.code = code;
        this.title = Objects.requireNonNull(title);
        this.detail = Objects.requireNonNull(detail);
    }

    public Response.Status getStatus() {
        return this.status;
    }

    public int getCode() {
        return this.code;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDetail() {
        return this.detail;
    }
}

