/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.exceptions;

import io.confluent.kafkarest.exceptions.StatusCodeException;
import io.confluent.kafkarest.exceptions.v2.V2ExceptionMapper;
import io.confluent.kafkarest.exceptions.v3.V3ExceptionMapper;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class ExceptionsModule
implements Feature {
    private static final LinkedHashMap<String, ExceptionMapper<StatusCodeException>> mappers = new LinkedHashMap();

    public boolean configure(FeatureContext configurable) {
        configurable.register(DelegatingExceptionHandler.class);
        return false;
    }

    static {
        mappers.put("v3", new V3ExceptionMapper());
        mappers.put("", new V2ExceptionMapper());
    }

    static final class DelegatingExceptionHandler
    implements ExceptionMapper<StatusCodeException> {
        private final UriInfo uriInfo;

        @Inject
        DelegatingExceptionHandler(@Context UriInfo uriInfo) {
            this.uriInfo = Objects.requireNonNull(uriInfo);
        }

        public Response toResponse(StatusCodeException exception) {
            for (Map.Entry<String, ExceptionMapper<StatusCodeException>> mapper : mappers.entrySet()) {
                if (!this.uriInfo.getPath().startsWith(mapper.getKey())) continue;
                return mapper.getValue().toResponse((Throwable)exception);
            }
            throw exception;
        }
    }
}

