/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.Cluster;
import io.confluent.kafkarest.entities.v3.AutoValue_ClusterData;
import io.confluent.kafkarest.entities.v3.Resource;
import jakarta.annotation.Nullable;
import java.util.Optional;

@AutoValue
public abstract class ClusterData
extends Resource {
    public static final String ELEMENT_TYPE = "kafka";

    ClusterData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="controller")
    public abstract Optional<Resource.Relationship> getController();

    @JsonProperty(value="acls")
    public abstract Resource.Relationship getAcls();

    @JsonProperty(value="brokers")
    public abstract Resource.Relationship getBrokers();

    @JsonProperty(value="broker_configs")
    public abstract Resource.Relationship getBrokerConfigs();

    @JsonProperty(value="consumer_groups")
    public abstract Resource.Relationship getConsumerGroups();

    @JsonProperty(value="topics")
    public abstract Resource.Relationship getTopics();

    @JsonProperty(value="partition_reassignments")
    public abstract Resource.Relationship getPartitionReassignments();

    public static Builder builder() {
        return new AutoValue_ClusterData.Builder().setKind("KafkaCluster");
    }

    public static Builder fromCluster(Cluster cluster) {
        return ClusterData.builder().setClusterId(cluster.getClusterId());
    }

    @JsonCreator
    static ClusterData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="controller") @Nullable Resource.Relationship controller, @JsonProperty(value="acls") Resource.Relationship acls, @JsonProperty(value="brokers") Resource.Relationship brokers, @JsonProperty(value="broker_configs") Resource.Relationship brokerConfigs, @JsonProperty(value="consumer_groups") Resource.Relationship consumerGroups, @JsonProperty(value="topics") Resource.Relationship topics, @JsonProperty(value="partition_reassignments") Resource.Relationship partitionReassignments) {
        return ((Builder)((Builder)ClusterData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setController(controller).setAcls(acls).setBrokers(brokers).setBrokerConfigs(brokerConfigs).setConsumerGroups(consumerGroups).setTopics(topics).setPartitionReassignments(partitionReassignments).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setController(@Nullable Resource.Relationship var1);

        public abstract Builder setAcls(Resource.Relationship var1);

        public abstract Builder setBrokers(Resource.Relationship var1);

        public abstract Builder setBrokerConfigs(Resource.Relationship var1);

        public abstract Builder setConsumerGroups(Resource.Relationship var1);

        public abstract Builder setTopics(Resource.Relationship var1);

        public abstract Builder setPartitionReassignments(Resource.Relationship var1);

        public abstract ClusterData build();
    }
}

