/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.ProduceBatchRequestEntry;
import io.confluent.kafkarest.entities.v3.ProduceRequest;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Optional;

final class AutoValue_ProduceBatchRequestEntry
extends ProduceBatchRequestEntry {
    private final JsonNode id;
    private final Optional<Integer> partitionId;
    private final ImmutableList<ProduceRequest.ProduceRequestHeader> headers;
    private final Optional<ProduceRequest.ProduceRequestData> key;
    private final Optional<ProduceRequest.ProduceRequestData> value;
    private final Optional<Instant> timestamp;
    private final long originalSize;

    private AutoValue_ProduceBatchRequestEntry(JsonNode id, Optional<Integer> partitionId, ImmutableList<ProduceRequest.ProduceRequestHeader> headers, Optional<ProduceRequest.ProduceRequestData> key, Optional<ProduceRequest.ProduceRequestData> value, Optional<Instant> timestamp, long originalSize) {
        this.id = id;
        this.partitionId = partitionId;
        this.headers = headers;
        this.key = key;
        this.value = value;
        this.timestamp = timestamp;
        this.originalSize = originalSize;
    }

    @Override
    @JsonProperty(value="id")
    public JsonNode getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="partition_id")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<Integer> getPartitionId() {
        return this.partitionId;
    }

    @Override
    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ImmutableList<ProduceRequest.ProduceRequestHeader> getHeaders() {
        return this.headers;
    }

    @Override
    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<ProduceRequest.ProduceRequestData> getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<ProduceRequest.ProduceRequestData> getValue() {
        return this.value;
    }

    @Override
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<Instant> getTimestamp() {
        return this.timestamp;
    }

    @Override
    @JsonIgnore
    public long getOriginalSize() {
        return this.originalSize;
    }

    public String toString() {
        return "ProduceBatchRequestEntry{id=" + String.valueOf(this.id) + ", partitionId=" + String.valueOf(this.partitionId) + ", headers=" + String.valueOf(this.headers) + ", key=" + String.valueOf(this.key) + ", value=" + String.valueOf(this.value) + ", timestamp=" + String.valueOf(this.timestamp) + ", originalSize=" + this.originalSize + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProduceBatchRequestEntry) {
            ProduceBatchRequestEntry that = (ProduceBatchRequestEntry)o;
            return this.id.equals((Object)that.getId()) && this.partitionId.equals(that.getPartitionId()) && this.headers.equals(that.getHeaders()) && this.key.equals(that.getKey()) && this.value.equals(that.getValue()) && this.timestamp.equals(that.getTimestamp()) && this.originalSize == that.getOriginalSize();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitionId.hashCode();
        h$ *= 1000003;
        h$ ^= this.headers.hashCode();
        h$ *= 1000003;
        h$ ^= this.key.hashCode();
        h$ *= 1000003;
        h$ ^= this.value.hashCode();
        h$ *= 1000003;
        h$ ^= this.timestamp.hashCode();
        h$ *= 1000003;
        return h$ ^= (int)(this.originalSize >>> 32 ^ this.originalSize);
    }

    static final class Builder
    extends ProduceBatchRequestEntry.Builder {
        private JsonNode id;
        private Optional<Integer> partitionId = Optional.empty();
        private ImmutableList<ProduceRequest.ProduceRequestHeader> headers;
        private Optional<ProduceRequest.ProduceRequestData> key = Optional.empty();
        private Optional<ProduceRequest.ProduceRequestData> value = Optional.empty();
        private Optional<Instant> timestamp = Optional.empty();
        private Long originalSize;

        Builder() {
        }

        @Override
        public ProduceBatchRequestEntry.Builder setId(JsonNode id) {
            if (id == null) {
                throw new NullPointerException("Null id");
            }
            this.id = id;
            return this;
        }

        @Override
        public ProduceBatchRequestEntry.Builder setPartitionId(@Nullable Integer partitionId) {
            this.partitionId = Optional.ofNullable(partitionId);
            return this;
        }

        @Override
        public ProduceBatchRequestEntry.Builder setHeaders(List<ProduceRequest.ProduceRequestHeader> headers) {
            this.headers = ImmutableList.copyOf(headers);
            return this;
        }

        @Override
        public ProduceBatchRequestEntry.Builder setKey(@Nullable ProduceRequest.ProduceRequestData key) {
            this.key = Optional.ofNullable(key);
            return this;
        }

        @Override
        public ProduceBatchRequestEntry.Builder setValue(@Nullable ProduceRequest.ProduceRequestData value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        @Override
        public ProduceBatchRequestEntry.Builder setTimestamp(@Nullable Instant timestamp) {
            this.timestamp = Optional.ofNullable(timestamp);
            return this;
        }

        @Override
        public ProduceBatchRequestEntry.Builder setOriginalSize(long originalSize) {
            this.originalSize = originalSize;
            return this;
        }

        @Override
        ProduceBatchRequestEntry autoBuild() {
            Object missing = "";
            if (this.id == null) {
                missing = (String)missing + " id";
            }
            if (this.headers == null) {
                missing = (String)missing + " headers";
            }
            if (this.originalSize == null) {
                missing = (String)missing + " originalSize";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_ProduceBatchRequestEntry(this.id, this.partitionId, this.headers, this.key, this.value, this.timestamp, this.originalSize);
        }
    }
}

