/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.ClusterData;
import io.confluent.kafkarest.entities.v3.ClusterDataList;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import java.util.List;

final class AutoValue_ClusterDataList
extends ClusterDataList {
    private final String kind;
    private final ResourceCollection.Metadata metadata;
    private final ImmutableList<ClusterData> data;

    private AutoValue_ClusterDataList(String kind, ResourceCollection.Metadata metadata, ImmutableList<ClusterData> data) {
        this.kind = kind;
        this.metadata = metadata;
        this.data = data;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ResourceCollection.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="data")
    public ImmutableList<ClusterData> getData() {
        return this.data;
    }

    public String toString() {
        return "ClusterDataList{kind=" + this.kind + ", metadata=" + String.valueOf(this.metadata) + ", data=" + String.valueOf(this.data) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ClusterDataList) {
            ClusterDataList that = (ClusterDataList)o;
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.data.equals(that.getData());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        return h$ ^= this.data.hashCode();
    }

    static final class Builder
    extends ClusterDataList.Builder {
        private String kind;
        private ResourceCollection.Metadata metadata;
        private ImmutableList<ClusterData> data;

        Builder() {
        }

        @Override
        public ClusterDataList.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        @Override
        public ClusterDataList.Builder setMetadata(ResourceCollection.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public ClusterDataList.Builder setData(List<ClusterData> data) {
            this.data = ImmutableList.copyOf(data);
            return this;
        }

        @Override
        public ClusterDataList build() {
            Object missing = "";
            if (this.kind == null) {
                missing = (String)missing + " kind";
            }
            if (this.metadata == null) {
                missing = (String)missing + " metadata";
            }
            if (this.data == null) {
                missing = (String)missing + " data";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_ClusterDataList(this.kind, this.metadata, this.data);
        }
    }
}

