/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.v3.BrokerData;
import io.confluent.kafkarest.entities.v3.Resource;
import jakarta.annotation.Nullable;
import java.util.Optional;

final class AutoValue_BrokerData
extends BrokerData {
    private final String kind;
    private final Resource.Metadata metadata;
    private final String clusterId;
    private final int brokerId;
    private final Optional<String> host;
    private final Optional<Integer> port;
    private final Optional<String> rack;
    private final Resource.Relationship configs;
    private final Resource.Relationship partitionReplicas;

    private AutoValue_BrokerData(String kind, Resource.Metadata metadata, String clusterId, int brokerId, Optional<String> host, Optional<Integer> port, Optional<String> rack, Resource.Relationship configs, Resource.Relationship partitionReplicas) {
        this.kind = kind;
        this.metadata = metadata;
        this.clusterId = clusterId;
        this.brokerId = brokerId;
        this.host = host;
        this.port = port;
        this.rack = rack;
        this.configs = configs;
        this.partitionReplicas = partitionReplicas;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public Resource.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="cluster_id")
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    @JsonProperty(value="broker_id")
    public int getBrokerId() {
        return this.brokerId;
    }

    @Override
    @JsonProperty(value="host")
    public Optional<String> getHost() {
        return this.host;
    }

    @Override
    @JsonProperty(value="port")
    public Optional<Integer> getPort() {
        return this.port;
    }

    @Override
    @JsonProperty(value="rack")
    public Optional<String> getRack() {
        return this.rack;
    }

    @Override
    @JsonProperty(value="configs")
    public Resource.Relationship getConfigs() {
        return this.configs;
    }

    @Override
    @JsonProperty(value="partition_replicas")
    public Resource.Relationship getPartitionReplicas() {
        return this.partitionReplicas;
    }

    public String toString() {
        return "BrokerData{kind=" + this.kind + ", metadata=" + String.valueOf(this.metadata) + ", clusterId=" + this.clusterId + ", brokerId=" + this.brokerId + ", host=" + String.valueOf(this.host) + ", port=" + String.valueOf(this.port) + ", rack=" + String.valueOf(this.rack) + ", configs=" + String.valueOf(this.configs) + ", partitionReplicas=" + String.valueOf(this.partitionReplicas) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BrokerData) {
            BrokerData that = (BrokerData)o;
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.clusterId.equals(that.getClusterId()) && this.brokerId == that.getBrokerId() && this.host.equals(that.getHost()) && this.port.equals(that.getPort()) && this.rack.equals(that.getRack()) && this.configs.equals(that.getConfigs()) && this.partitionReplicas.equals(that.getPartitionReplicas());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.brokerId;
        h$ *= 1000003;
        h$ ^= this.host.hashCode();
        h$ *= 1000003;
        h$ ^= this.port.hashCode();
        h$ *= 1000003;
        h$ ^= this.rack.hashCode();
        h$ *= 1000003;
        h$ ^= this.configs.hashCode();
        h$ *= 1000003;
        return h$ ^= this.partitionReplicas.hashCode();
    }

    static final class Builder
    extends BrokerData.Builder {
        private String kind;
        private Resource.Metadata metadata;
        private String clusterId;
        private Integer brokerId;
        private Optional<String> host = Optional.empty();
        private Optional<Integer> port = Optional.empty();
        private Optional<String> rack = Optional.empty();
        private Resource.Relationship configs;
        private Resource.Relationship partitionReplicas;

        Builder() {
        }

        @Override
        public BrokerData.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        @Override
        public BrokerData.Builder setMetadata(Resource.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public BrokerData.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public BrokerData.Builder setBrokerId(int brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        @Override
        public BrokerData.Builder setHost(@Nullable String host) {
            this.host = Optional.ofNullable(host);
            return this;
        }

        @Override
        public BrokerData.Builder setPort(@Nullable Integer port) {
            this.port = Optional.ofNullable(port);
            return this;
        }

        @Override
        public BrokerData.Builder setRack(@Nullable String rack) {
            this.rack = Optional.ofNullable(rack);
            return this;
        }

        @Override
        public BrokerData.Builder setConfigs(Resource.Relationship configs) {
            if (configs == null) {
                throw new NullPointerException("Null configs");
            }
            this.configs = configs;
            return this;
        }

        @Override
        public BrokerData.Builder setPartitionReplicas(Resource.Relationship partitionReplicas) {
            if (partitionReplicas == null) {
                throw new NullPointerException("Null partitionReplicas");
            }
            this.partitionReplicas = partitionReplicas;
            return this;
        }

        @Override
        public BrokerData build() {
            Object missing = "";
            if (this.kind == null) {
                missing = (String)missing + " kind";
            }
            if (this.metadata == null) {
                missing = (String)missing + " metadata";
            }
            if (this.clusterId == null) {
                missing = (String)missing + " clusterId";
            }
            if (this.brokerId == null) {
                missing = (String)missing + " brokerId";
            }
            if (this.configs == null) {
                missing = (String)missing + " configs";
            }
            if (this.partitionReplicas == null) {
                missing = (String)missing + " partitionReplicas";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_BrokerData(this.kind, this.metadata, this.clusterId, this.brokerId, this.host, this.port, this.rack, this.configs, this.partitionReplicas);
        }
    }
}

