/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.AlterConfigCommand;
import io.confluent.kafkarest.entities.v3.AutoValue_AlterConfigBatchRequestData;
import io.confluent.kafkarest.entities.v3.AutoValue_AlterConfigBatchRequestData_AlterEntry;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@AutoValue
public abstract class AlterConfigBatchRequestData {
    AlterConfigBatchRequestData() {
    }

    @JsonProperty(value="data")
    public abstract ImmutableList<AlterEntry> getData();

    @JsonProperty(value="validate_only")
    public abstract Optional<Boolean> getValidateOnly();

    public static AlterConfigBatchRequestData create(List<AlterEntry> data) {
        return new AutoValue_AlterConfigBatchRequestData((ImmutableList<AlterEntry>)ImmutableList.copyOf(data), Optional.empty());
    }

    public static AlterConfigBatchRequestData create(List<AlterEntry> data, Optional<Boolean> validateOnly) {
        return new AutoValue_AlterConfigBatchRequestData((ImmutableList<AlterEntry>)ImmutableList.copyOf(data), validateOnly);
    }

    @JsonCreator
    static AlterConfigBatchRequestData fromJson(@JsonProperty(value="data") List<AlterEntry> data, @JsonProperty(value="validate_only") Optional<Boolean> validateOnly) {
        return AlterConfigBatchRequestData.create(data, validateOnly);
    }

    public final List<AlterConfigCommand> toAlterConfigCommands() {
        ArrayList<AlterConfigCommand> commands = new ArrayList<AlterConfigCommand>();
        block4: for (AlterEntry entry : this.getData()) {
            switch (entry.getOperation()) {
                case SET: {
                    commands.add(AlterConfigCommand.set(entry.getName(), entry.getValue().orElse(null)));
                    continue block4;
                }
                case DELETE: {
                    commands.add(AlterConfigCommand.delete(entry.getName()));
                    continue block4;
                }
            }
            throw new AssertionError((Object)"unreachable");
        }
        return Collections.unmodifiableList(commands);
    }

    @AutoValue
    public static abstract class AlterEntry {
        @JsonProperty(value="name")
        public abstract String getName();

        @JsonProperty(value="value")
        public abstract Optional<String> getValue();

        @JsonProperty(value="operation")
        public abstract AlterOperation getOperation();

        public static Builder builder() {
            return new AutoValue_AlterConfigBatchRequestData_AlterEntry.Builder().setOperation(AlterOperation.SET);
        }

        @JsonCreator
        static AlterEntry fromJson(@JsonProperty(value="name") String name, @JsonProperty(value="value") @Nullable String value, @JsonProperty(value="operation") @Nullable AlterOperation operation) {
            return AlterEntry.builder().setName(name).setValue(value).setOperation(operation != null ? operation : AlterOperation.SET).build();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setName(String var1);

            public abstract Builder setValue(@Nullable String var1);

            public abstract Builder setOperation(AlterOperation var1);

            public abstract AlterEntry build();
        }
    }

    public static enum AlterOperation {
        SET,
        DELETE;

    }
}

