/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import io.confluent.kafkarest.entities.ProduceRecord;
import io.confluent.kafkarest.entities.ProduceRequest;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public final class SchemaPartitionProduceRequest {
    @NotEmpty
    @Nullable
    private final List<SchemaPartitionProduceRecord> records;
    @Nullable
    private final String keySchema;
    @Nullable
    private final Integer keySchemaId;
    @Nullable
    private final String valueSchema;
    @Nullable
    private final Integer valueSchemaId;

    @JsonCreator
    private SchemaPartitionProduceRequest(@JsonProperty(value="records") @Nullable List<SchemaPartitionProduceRecord> records, @JsonProperty(value="key_schema") @Nullable String keySchema, @JsonProperty(value="key_schema_id") @Nullable Integer keySchemaId, @JsonProperty(value="value_schema") @Nullable String valueSchema, @JsonProperty(value="value_schema_id") @Nullable Integer valueSchemaId) {
        this.records = records;
        this.keySchema = keySchema;
        this.keySchemaId = keySchemaId;
        this.valueSchema = valueSchema;
        this.valueSchemaId = valueSchemaId;
    }

    @JsonProperty(value="records")
    @Nullable
    public List<SchemaPartitionProduceRecord> getRecords() {
        return this.records;
    }

    @JsonProperty(value="key_schema")
    @Nullable
    public String getKeySchema() {
        return this.keySchema;
    }

    @JsonProperty(value="key_schema_id")
    @Nullable
    public Integer getKeySchemaId() {
        return this.keySchemaId;
    }

    @JsonProperty(value="value_schema")
    @Nullable
    public String getValueSchema() {
        return this.valueSchema;
    }

    @JsonProperty(value="value_schema_id")
    @Nullable
    public Integer getValueSchemaId() {
        return this.valueSchemaId;
    }

    public static SchemaPartitionProduceRequest create(List<SchemaPartitionProduceRecord> records, @Nullable String keySchema, @Nullable Integer keySchemaId, @Nullable String valueSchema, @Nullable Integer valueSchemaId) {
        if (records.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return new SchemaPartitionProduceRequest(records, keySchema, keySchemaId, valueSchema, valueSchemaId);
    }

    public ProduceRequest<JsonNode, JsonNode> toProduceRequest() {
        if (this.records == null || this.records.isEmpty()) {
            throw new IllegalStateException();
        }
        return ProduceRequest.create(this.records.stream().map(record -> ProduceRecord.create(record.key, record.value, null)).collect(Collectors.toList()), this.keySchema, this.keySchemaId, this.valueSchema, this.valueSchemaId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaPartitionProduceRequest that = (SchemaPartitionProduceRequest)o;
        return Objects.equals(this.records, that.records) && Objects.equals(this.keySchema, that.keySchema) && Objects.equals(this.keySchemaId, that.keySchemaId) && Objects.equals(this.valueSchema, that.valueSchema) && Objects.equals(this.valueSchemaId, that.valueSchemaId);
    }

    public int hashCode() {
        return Objects.hash(this.records, this.keySchema, this.keySchemaId, this.valueSchema, this.valueSchemaId);
    }

    public String toString() {
        return new StringJoiner(", ", SchemaPartitionProduceRequest.class.getSimpleName() + "[", "]").add("records=" + String.valueOf(this.records)).add("keySchema='" + this.keySchema + "'").add("keySchemaId=" + this.keySchemaId).add("valueSchema='" + this.valueSchema + "'").add("valueSchemaId=" + this.valueSchemaId).toString();
    }

    public static final class SchemaPartitionProduceRecord {
        @Nullable
        private final JsonNode key;
        @Nullable
        private final JsonNode value;

        @JsonCreator
        public SchemaPartitionProduceRecord(@JsonProperty(value="key") @Nullable JsonNode key, @JsonProperty(value="value") @Nullable JsonNode value) {
            this.key = key;
            this.value = value;
        }

        @JsonProperty(value="key")
        @Nullable
        public JsonNode getKey() {
            return this.key;
        }

        @JsonProperty(value="value")
        @Nullable
        public JsonNode getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemaPartitionProduceRecord that = (SchemaPartitionProduceRecord)o;
            return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public String toString() {
            return new StringJoiner(", ", SchemaPartitionProduceRecord.class.getSimpleName() + "[", "]").add("key=" + String.valueOf(this.key)).add("value=" + String.valueOf(this.value)).toString();
        }
    }
}

