/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.Objects;
import java.util.StringJoiner;

public final class PartitionOffset {
    @PositiveOrZero
    @Nullable
    private final Integer partition;
    @PositiveOrZero
    @Nullable
    private final Long offset;
    @Nullable
    private final Integer errorCode;
    @Nullable
    private final String error;

    @JsonCreator
    public PartitionOffset(@JsonProperty(value="partition") @Nullable Integer partition, @JsonProperty(value="offset") @Nullable Long offset, @JsonProperty(value="error_code") @Nullable Integer errorCode, @JsonProperty(value="error") @Nullable String error) {
        this.partition = partition;
        this.offset = offset;
        this.errorCode = errorCode;
        this.error = error;
    }

    @JsonProperty
    @Nullable
    public Integer getPartition() {
        return this.partition;
    }

    @JsonProperty
    @Nullable
    public Long getOffset() {
        return this.offset;
    }

    @JsonProperty(value="error_code")
    @Nullable
    public Integer getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty(value="error")
    @Nullable
    public String getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionOffset that = (PartitionOffset)o;
        return Objects.equals(this.partition, that.partition) && Objects.equals(this.offset, that.offset) && Objects.equals(this.errorCode, that.errorCode) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.offset, this.errorCode, this.error);
    }

    public String toString() {
        return new StringJoiner(", ", PartitionOffset.class.getSimpleName() + "[", "]").add("partition=" + this.partition).add("offset=" + this.offset).add("errorCode=" + this.errorCode).add("error='" + this.error + "'").toString();
    }
}

