/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v2.AutoValue_ConsumerSeekRequest;
import io.confluent.kafkarest.entities.v2.AutoValue_ConsumerSeekRequest_PartitionOffset;
import io.confluent.kafkarest.entities.v2.AutoValue_ConsumerSeekRequest_PartitionTimestamp;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Optional;

@AutoValue
public abstract class ConsumerSeekRequest {
    ConsumerSeekRequest() {
    }

    @JsonProperty(value="offsets")
    public abstract ImmutableList<PartitionOffset> getOffsets();

    @JsonProperty(value="timestamps")
    public abstract ImmutableList<PartitionTimestamp> getTimestamps();

    @JsonCreator
    static ConsumerSeekRequest fromJson(@JsonProperty(value="offsets") @Nullable List<PartitionOffset> offsets, @JsonProperty(value="timestamps") @Nullable List<PartitionTimestamp> timestamps) {
        return new AutoValue_ConsumerSeekRequest((ImmutableList<PartitionOffset>)(offsets != null ? ImmutableList.copyOf(offsets) : ImmutableList.of()), (ImmutableList<PartitionTimestamp>)(timestamps != null ? ImmutableList.copyOf(timestamps) : ImmutableList.of()));
    }

    @AutoValue
    public static abstract class PartitionTimestamp {
        PartitionTimestamp() {
        }

        @JsonProperty(value="topic")
        public abstract String getTopic();

        @JsonProperty(value="partition")
        public abstract int getPartition();

        @JsonProperty(value="timestamp")
        public abstract Instant getTimestamp();

        @JsonProperty(value="metadata")
        public abstract Optional<String> getMetadata();

        @JsonCreator
        static PartitionTimestamp fromJson(@JsonProperty(value="topic") String topic, @JsonProperty(value="partition") int partition, @JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="metadata") @Nullable String metadata) {
            return PartitionTimestamp.build().setTopic(topic).setPartition(partition).setTimestamp(timestamp).setMetadata(metadata).build();
        }

        public static Builder build() {
            return new AutoValue_ConsumerSeekRequest_PartitionTimestamp.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            Builder() {
            }

            public abstract Builder setTopic(String var1);

            public abstract Builder setPartition(int var1);

            public abstract Builder setTimestamp(Instant var1);

            public abstract Builder setMetadata(@Nullable String var1);

            public abstract PartitionTimestamp build();
        }
    }

    @AutoValue
    public static abstract class PartitionOffset {
        PartitionOffset() {
        }

        @JsonProperty(value="topic")
        public abstract String getTopic();

        @JsonProperty(value="partition")
        public abstract int getPartition();

        @JsonProperty(value="offset")
        public abstract long getOffset();

        @JsonProperty(value="metadata")
        public abstract Optional<String> getMetadata();

        @JsonCreator
        static PartitionOffset fromJson(@JsonProperty(value="topic") String topic, @JsonProperty(value="partition") int partition, @JsonProperty(value="offset") long offset, @JsonProperty(value="metadata") @Nullable String metadata) {
            return PartitionOffset.build().setTopic(topic).setPartition(partition).setOffset(offset).setMetadata(metadata).build();
        }

        public static Builder build() {
            return new AutoValue_ConsumerSeekRequest_PartitionOffset.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            Builder() {
            }

            public abstract Builder setTopic(String var1);

            public abstract Builder setPartition(int var1);

            public abstract Builder setOffset(long var1);

            public abstract Builder setMetadata(@Nullable String var1);

            public abstract PartitionOffset build();
        }
    }
}

