/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.confluent.kafkarest.entities.TopicPartitionOffset;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public final class CommitOffsetsResponse {
    @Nullable
    private final List<Offset> offsets;

    @JsonCreator
    private CommitOffsetsResponse(@Nullable List<Offset> offsets) {
        this.offsets = offsets;
    }

    @JsonValue
    @Nullable
    public List<Offset> getOffsets() {
        return this.offsets;
    }

    public static CommitOffsetsResponse fromOffsets(List<TopicPartitionOffset> offsets) {
        return new CommitOffsetsResponse(offsets.stream().map(Offset::fromTopicPartitionOffset).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitOffsetsResponse that = (CommitOffsetsResponse)o;
        return Objects.equals(this.offsets, that.offsets);
    }

    public int hashCode() {
        return Objects.hash(this.offsets);
    }

    public String toString() {
        return new StringJoiner(", ", CommitOffsetsResponse.class.getSimpleName() + "[", "]").add("offsets=" + String.valueOf(this.offsets)).toString();
    }

    public static final class Offset {
        @NotEmpty
        @Nullable
        private String topic;
        @PositiveOrZero
        @Nullable
        private Integer partition;
        @PositiveOrZero
        @Nullable
        private Long consumed;
        @PositiveOrZero
        @Nullable
        private Long committed;

        @JsonCreator
        private Offset(@JsonProperty(value="topic") @Nullable String topic, @JsonProperty(value="partition") @Nullable Integer partition, @JsonProperty(value="consumed") @Nullable Long consumed, @JsonProperty(value="committed") @Nullable Long committed) {
            this.topic = topic;
            this.partition = partition;
            this.consumed = consumed;
            this.committed = committed;
        }

        @JsonProperty
        @Nullable
        public String getTopic() {
            return this.topic;
        }

        @JsonProperty
        @Nullable
        public Integer getPartition() {
            return this.partition;
        }

        @JsonProperty
        @Nullable
        public Long getConsumed() {
            return this.consumed;
        }

        @JsonProperty
        @Nullable
        public Long getCommitted() {
            return this.committed;
        }

        public static Offset fromTopicPartitionOffset(TopicPartitionOffset offset) {
            return new Offset(offset.getTopic(), offset.getPartition(), offset.getConsumed(), offset.getCommitted());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Offset offset = (Offset)o;
            return Objects.equals(this.topic, offset.topic) && Objects.equals(this.partition, offset.partition) && Objects.equals(this.consumed, offset.consumed) && Objects.equals(this.committed, offset.committed);
        }

        public int hashCode() {
            return Objects.hash(this.topic, this.partition, this.consumed, this.committed);
        }

        public String toString() {
            return new StringJoiner(", ", Offset.class.getSimpleName() + "[", "]").add("topic='" + this.topic + "'").add("partition=" + this.partition).add("consumed=" + this.consumed).add("committed=" + this.committed).toString();
        }
    }
}

