/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.ConfigSource;
import io.confluent.kafkarest.entities.ConfigSynonym;
import io.confluent.kafkarest.entities.TopicConfig;
import jakarta.annotation.Nullable;
import java.util.List;

final class AutoValue_TopicConfig
extends TopicConfig {
    private final String clusterId;
    private final String name;
    private final String value;
    private final boolean default0;
    private final boolean readOnly;
    private final boolean sensitive;
    private final ConfigSource source;
    private final ImmutableList<ConfigSynonym> synonyms;
    private final String topicName;

    private AutoValue_TopicConfig(String clusterId, String name, @Nullable String value, boolean default0, boolean readOnly, boolean sensitive, ConfigSource source, ImmutableList<ConfigSynonym> synonyms, String topicName) {
        this.clusterId = clusterId;
        this.name = name;
        this.value = value;
        this.default0 = default0;
        this.readOnly = readOnly;
        this.sensitive = sensitive;
        this.source = source;
        this.synonyms = synonyms;
        this.topicName = topicName;
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isDefault() {
        return this.default0;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isSensitive() {
        return this.sensitive;
    }

    @Override
    public ConfigSource getSource() {
        return this.source;
    }

    @Override
    public ImmutableList<ConfigSynonym> getSynonyms() {
        return this.synonyms;
    }

    @Override
    public String getTopicName() {
        return this.topicName;
    }

    public String toString() {
        return "TopicConfig{clusterId=" + this.clusterId + ", name=" + this.name + ", value=" + this.value + ", default=" + this.default0 + ", readOnly=" + this.readOnly + ", sensitive=" + this.sensitive + ", source=" + String.valueOf((Object)this.source) + ", synonyms=" + String.valueOf(this.synonyms) + ", topicName=" + this.topicName + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TopicConfig) {
            TopicConfig that = (TopicConfig)o;
            return this.clusterId.equals(that.getClusterId()) && this.name.equals(that.getName()) && (this.value == null ? that.getValue() == null : this.value.equals(that.getValue())) && this.default0 == that.isDefault() && this.readOnly == that.isReadOnly() && this.sensitive == that.isSensitive() && this.source.equals((Object)that.getSource()) && this.synonyms.equals(that.getSynonyms()) && this.topicName.equals(that.getTopicName());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.value == null ? 0 : this.value.hashCode();
        h$ *= 1000003;
        h$ ^= this.default0 ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.readOnly ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.sensitive ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.source.hashCode();
        h$ *= 1000003;
        h$ ^= this.synonyms.hashCode();
        h$ *= 1000003;
        return h$ ^= this.topicName.hashCode();
    }

    static final class Builder
    extends TopicConfig.Builder {
        private String clusterId;
        private String name;
        private String value;
        private Boolean default0;
        private Boolean readOnly;
        private Boolean sensitive;
        private ConfigSource source;
        private ImmutableList<ConfigSynonym> synonyms;
        private String topicName;

        Builder() {
        }

        @Override
        public TopicConfig.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public TopicConfig.Builder setName(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public TopicConfig.Builder setValue(@Nullable String value) {
            this.value = value;
            return this;
        }

        @Override
        public TopicConfig.Builder setDefault(boolean default0) {
            this.default0 = default0;
            return this;
        }

        @Override
        public TopicConfig.Builder setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @Override
        public TopicConfig.Builder setSensitive(boolean sensitive) {
            this.sensitive = sensitive;
            return this;
        }

        @Override
        public TopicConfig.Builder setSource(ConfigSource source) {
            if (source == null) {
                throw new NullPointerException("Null source");
            }
            this.source = source;
            return this;
        }

        @Override
        public TopicConfig.Builder setSynonyms(List<ConfigSynonym> synonyms) {
            this.synonyms = ImmutableList.copyOf(synonyms);
            return this;
        }

        @Override
        public TopicConfig.Builder setTopicName(String topicName) {
            if (topicName == null) {
                throw new NullPointerException("Null topicName");
            }
            this.topicName = topicName;
            return this;
        }

        @Override
        public TopicConfig build() {
            Object missing = "";
            if (this.clusterId == null) {
                missing = (String)missing + " clusterId";
            }
            if (this.name == null) {
                missing = (String)missing + " name";
            }
            if (this.default0 == null) {
                missing = (String)missing + " default";
            }
            if (this.readOnly == null) {
                missing = (String)missing + " readOnly";
            }
            if (this.sensitive == null) {
                missing = (String)missing + " sensitive";
            }
            if (this.source == null) {
                missing = (String)missing + " source";
            }
            if (this.synonyms == null) {
                missing = (String)missing + " synonyms";
            }
            if (this.topicName == null) {
                missing = (String)missing + " topicName";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_TopicConfig(this.clusterId, this.name, this.value, this.default0, this.readOnly, this.sensitive, this.source, this.synonyms, this.topicName);
        }
    }
}

