/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.AutoValue_Acl;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;

@AutoValue
public abstract class Acl {
    Acl() {
    }

    public abstract String getClusterId();

    public abstract ResourceType getResourceType();

    public abstract String getResourceName();

    public abstract PatternType getPatternType();

    public abstract String getPrincipal();

    public abstract String getHost();

    public abstract Operation getOperation();

    public abstract Permission getPermission();

    public static Builder builder() {
        return new AutoValue_Acl.Builder();
    }

    public static Builder fromAclBinding(AclBinding acl) {
        return Acl.builder().setResourceType(ResourceType.fromAdminResourceType(acl.pattern().resourceType())).setResourceName(acl.pattern().name()).setPatternType(PatternType.fromAdminPatternType(acl.pattern().patternType())).setPrincipal(acl.entry().principal()).setHost(acl.entry().host()).setOperation(Operation.fromAclOperation(acl.entry().operation())).setPermission(Permission.fromAclPermissionType(acl.entry().permissionType()));
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setResourceType(ResourceType var1);

        public abstract Builder setResourceName(String var1);

        public abstract Builder setPatternType(PatternType var1);

        public abstract Builder setPrincipal(String var1);

        public abstract Builder setHost(String var1);

        public abstract Builder setOperation(Operation var1);

        public abstract Builder setPermission(Permission var1);

        public abstract Acl build();
    }

    public static enum ResourceType {
        UNKNOWN,
        ANY,
        TOPIC,
        GROUP,
        CLUSTER,
        TRANSACTIONAL_ID,
        DELEGATION_TOKEN;


        public static ResourceType fromAdminResourceType(org.apache.kafka.common.resource.ResourceType resourceType) {
            try {
                return ResourceType.valueOf(resourceType.name());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public org.apache.kafka.common.resource.ResourceType toAdminResourceType() {
            try {
                return org.apache.kafka.common.resource.ResourceType.valueOf((String)this.name());
            }
            catch (IllegalArgumentException e) {
                return org.apache.kafka.common.resource.ResourceType.UNKNOWN;
            }
        }
    }

    public static enum PatternType {
        UNKNOWN,
        ANY,
        MATCH,
        LITERAL,
        PREFIXED;


        public static PatternType fromAdminPatternType(org.apache.kafka.common.resource.PatternType patternType) {
            try {
                return PatternType.valueOf(patternType.name());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public org.apache.kafka.common.resource.PatternType toAdminPatternType() {
            try {
                return org.apache.kafka.common.resource.PatternType.valueOf((String)this.name());
            }
            catch (IllegalArgumentException e) {
                return org.apache.kafka.common.resource.PatternType.UNKNOWN;
            }
        }
    }

    public static enum Operation {
        UNKNOWN,
        ANY,
        ALL,
        READ,
        WRITE,
        CREATE,
        DELETE,
        ALTER,
        DESCRIBE,
        CLUSTER_ACTION,
        DESCRIBE_CONFIGS,
        ALTER_CONFIGS,
        IDEMPOTENT_WRITE;


        public static Operation fromAclOperation(AclOperation aclOperation) {
            try {
                return Operation.valueOf(aclOperation.name());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public AclOperation toAclOperation() {
            try {
                return AclOperation.valueOf((String)this.name());
            }
            catch (IllegalArgumentException e) {
                return AclOperation.UNKNOWN;
            }
        }
    }

    public static enum Permission {
        UNKNOWN,
        ANY,
        DENY,
        ALLOW;


        public static Permission fromAclPermissionType(AclPermissionType aclPermissionType) {
            try {
                return Permission.valueOf(aclPermissionType.name());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public AclPermissionType toAclPermissionType() {
            try {
                return AclPermissionType.valueOf((String)this.name());
            }
            catch (IllegalArgumentException e) {
                return AclPermissionType.UNKNOWN;
            }
        }
    }
}

