/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaUtils;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerializer;
import io.confluent.kafka.serializers.json.AbstractKafkaJsonSchemaSerializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializer;
import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.config.ConfigModule;
import io.confluent.kafkarest.controllers.SchemaRecordSerializer;
import io.confluent.kafkarest.entities.EmbeddedFormat;
import io.confluent.kafkarest.entities.RegisteredSchema;
import io.confluent.kafkarest.exceptions.BadRequestException;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.avro.AvroTypeException;
import org.everit.json.schema.ValidationException;

final class SchemaRecordSerializerImpl
implements SchemaRecordSerializer {
    private final boolean nullRequestBodyAlwaysPublishEmptyRecord;
    private final AvroSerializer avroSerializer;
    private final JsonSchemaSerializer jsonschemaSerializer;
    private final ProtobufSerializer protobufSerializer;

    SchemaRecordSerializerImpl(SchemaRegistryClient schemaRegistryClient, @ConfigModule.AvroSerializerConfigs Map<String, Object> avroSerializerConfigs, @ConfigModule.JsonschemaSerializerConfigs Map<String, Object> jsonschemaSerializerConfigs, @ConfigModule.ProtobufSerializerConfigs Map<String, Object> protobufSerializerConfigs, boolean nullRequestBodyAlwaysPublishEmptyRecord) {
        Objects.requireNonNull(schemaRegistryClient);
        this.avroSerializer = new AvroSerializer(schemaRegistryClient, avroSerializerConfigs);
        this.jsonschemaSerializer = new JsonSchemaSerializer(schemaRegistryClient, jsonschemaSerializerConfigs);
        this.protobufSerializer = new ProtobufSerializer(schemaRegistryClient, protobufSerializerConfigs);
        this.nullRequestBodyAlwaysPublishEmptyRecord = nullRequestBodyAlwaysPublishEmptyRecord;
    }

    @Override
    public Optional<ByteString> serialize(EmbeddedFormat format, String topicName, Optional<RegisteredSchema> schema, JsonNode data, boolean isKey) {
        Preconditions.checkArgument((boolean)format.requiresSchema());
        if (this.nullRequestBodyAlwaysPublishEmptyRecord && data.isNull()) {
            return Optional.empty();
        }
        if (data.isNull() && schema.isEmpty()) {
            return Optional.empty();
        }
        if (schema.isEmpty()) {
            throw isKey ? Errors.keySchemaMissingException() : Errors.valueSchemaMissingException();
        }
        switch (format) {
            case AVRO: {
                return Optional.of(this.serializeAvro(schema.get().getSubject(), schema.get(), data));
            }
            case JSONSCHEMA: {
                return Optional.of(this.serializeJsonschema(schema.get().getSubject(), schema.get(), data));
            }
            case PROTOBUF: {
                return Optional.of(this.serializeProtobuf(schema.get().getSubject(), topicName, schema.get(), data, isKey));
            }
        }
        throw new AssertionError((Object)String.format("Unexpected enum constant: %s", new Object[]{format}));
    }

    private ByteString serializeAvro(String subject, RegisteredSchema schema, JsonNode data) {
        Object record;
        AvroSchema avroSchema = (AvroSchema)schema.getSchema();
        try {
            record = AvroSchemaUtils.toObject((JsonNode)data, (AvroSchema)avroSchema);
        }
        catch (IOException | AvroTypeException e) {
            throw new BadRequestException(e.getMessage(), e);
        }
        return ByteString.copyFrom((byte[])this.avroSerializer.serialize(subject, avroSchema, record));
    }

    private ByteString serializeJsonschema(String subject, RegisteredSchema schema, JsonNode data) {
        Object record;
        JsonSchema jsonSchema = (JsonSchema)schema.getSchema();
        try {
            record = JsonSchemaUtils.toObject((JsonNode)data, (JsonSchema)jsonSchema);
        }
        catch (IOException | ValidationException e) {
            throw new BadRequestException(e.getMessage(), e);
        }
        return ByteString.copyFrom((byte[])this.jsonschemaSerializer.serialize(subject, jsonSchema, record));
    }

    private ByteString serializeProtobuf(String subject, String topicName, RegisteredSchema schema, JsonNode data, boolean isKey) {
        Message record;
        ProtobufSchema protobufSchema = (ProtobufSchema)schema.getSchema();
        try {
            record = (Message)ProtobufSchemaUtils.toObject((JsonNode)data, (ProtobufSchema)protobufSchema);
        }
        catch (IOException e) {
            throw new BadRequestException(e.getMessage(), e);
        }
        return ByteString.copyFrom((byte[])this.protobufSerializer.serialize(subject, topicName, protobufSchema, record, isKey));
    }

    private static final class AvroSerializer
    extends AbstractKafkaAvroSerializer {
        private AvroSerializer(SchemaRegistryClient schemaRegistryClient, Map<String, Object> configs) {
            this.schemaRegistry = Objects.requireNonNull(schemaRegistryClient);
            this.configure(this.serializerConfig(configs));
        }

        private byte[] serialize(String subject, AvroSchema schema, Object data) {
            return this.serializeImpl(subject, data, schema);
        }
    }

    private static final class JsonSchemaSerializer
    extends AbstractKafkaJsonSchemaSerializer<Object> {
        private JsonSchemaSerializer(SchemaRegistryClient schemaRegistryClient, Map<String, Object> configs) {
            this.schemaRegistry = Objects.requireNonNull(schemaRegistryClient);
            this.configure(this.serializerConfig(configs));
        }

        private byte[] serialize(String subject, JsonSchema schema, Object data) {
            return this.serializeImpl(subject, JsonSchemaUtils.getValue((Object)data), schema);
        }
    }

    private static final class ProtobufSerializer
    extends KafkaProtobufSerializer<Message> {
        private ProtobufSerializer(SchemaRegistryClient schemaRegistryClient, Map<String, Object> configs) {
            this.schemaRegistry = Objects.requireNonNull(schemaRegistryClient);
            this.configure(this.serializerConfig(configs));
        }

        private byte[] serialize(String subject, String topicName, ProtobufSchema schema, Message data, boolean isKey) {
            return this.serializeImpl(subject, topicName, isKey, data, schema);
        }
    }
}

