/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.common.KafkaFutures;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.ConsumerGroupManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.entities.Cluster;
import io.confluent.kafkarest.entities.ConsumerGroup;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.errors.GroupIdNotFoundException;

final class ConsumerGroupManagerImpl
implements ConsumerGroupManager {
    private final Admin adminClient;
    private final ClusterManager clusterManager;

    @Inject
    ConsumerGroupManagerImpl(Admin adminClient, ClusterManager clusterManager) {
        this.adminClient = Objects.requireNonNull(adminClient);
        this.clusterManager = Objects.requireNonNull(clusterManager);
    }

    @Override
    public CompletableFuture<List<ConsumerGroup>> listConsumerGroups(String clusterId) {
        return ((CompletableFuture)((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists(cluster, "Cluster %s could not be found.", clusterId))).thenCompose(cluster -> KafkaFutures.toCompletableFuture(this.adminClient.listConsumerGroups().all()))).thenCompose(listings -> this.getConsumerGroups(clusterId, listings.stream().map(ConsumerGroupListing::groupId).collect(Collectors.toList())));
    }

    @Override
    public CompletableFuture<Optional<ConsumerGroup>> getConsumerGroup(String clusterId, String consumerGroupId) {
        return ((CompletableFuture)((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists(cluster, "Cluster %s could not be found.", clusterId))).thenCompose(cluster -> this.getConsumerGroups(clusterId, Collections.singletonList(consumerGroupId)))).thenApply(consumerGroups -> consumerGroups.stream().findAny());
    }

    private CompletableFuture<List<ConsumerGroup>> getConsumerGroups(String clusterId, List<String> consumerGroupIds) {
        return ((CompletableFuture)KafkaFutures.toCompletableFuture(this.adminClient.describeConsumerGroups(consumerGroupIds).all()).exceptionally(error -> {
            if (error.getCause() instanceof GroupIdNotFoundException) {
                return Collections.emptyMap();
            }
            throw new CompletionException((Throwable)error);
        })).thenApply(descriptions -> descriptions.values().stream().filter(description -> !description.isSimpleConsumerGroup() || description.groupState() != GroupState.DEAD).map(description -> ConsumerGroup.fromConsumerGroupDescription(clusterId, description)).collect(Collectors.toList()));
    }
}

