/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafkarest.controllers.AbstractConsumerLagManager;
import io.confluent.kafkarest.controllers.ConsumerGroupLagSummaryManager;
import io.confluent.kafkarest.controllers.ConsumerGroupManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.entities.Consumer;
import io.confluent.kafkarest.entities.ConsumerGroup;
import io.confluent.kafkarest.entities.ConsumerGroupLagSummary;
import io.confluent.kafkarest.entities.Partition;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConsumerGroupLagSummaryManagerImpl
extends AbstractConsumerLagManager
implements ConsumerGroupLagSummaryManager {
    private final ConsumerGroupManager consumerGroupManager;
    private static final Logger log = LoggerFactory.getLogger(ConsumerGroupLagSummaryManagerImpl.class);

    @Inject
    ConsumerGroupLagSummaryManagerImpl(Admin kafkaAdminClient, ConsumerGroupManager consumerGroupManager) {
        super(kafkaAdminClient);
        this.consumerGroupManager = Objects.requireNonNull(consumerGroupManager);
    }

    @Override
    public CompletableFuture<Optional<ConsumerGroupLagSummary>> getConsumerGroupLagSummary(String clusterId, String consumerGroupId) {
        return ((CompletableFuture)this.consumerGroupManager.getConsumerGroup(clusterId, consumerGroupId).thenApply(consumerGroup -> (ConsumerGroup)Entities.checkEntityExists(consumerGroup, "Consumer Group %s could not be found.", consumerGroupId))).thenCompose(consumerGroup -> ((CompletableFuture)this.getCurrentOffsets(consumerGroupId).thenApply(fetchedCurrentOffsets -> ConsumerGroupLagSummaryManagerImpl.checkOffsetsExist(fetchedCurrentOffsets, "Consumer group offsets could not be found.", new Object[0]))).thenCompose(fetchedCurrentOffsets -> this.getLatestOffsets((Map<TopicPartition, OffsetAndMetadata>)fetchedCurrentOffsets).thenApply(latestOffsets -> Optional.of(ConsumerGroupLagSummaryManagerImpl.createConsumerGroupLagSummary(clusterId, consumerGroup, fetchedCurrentOffsets, latestOffsets)))));
    }

    private static ConsumerGroupLagSummary createConsumerGroupLagSummary(String clusterId, ConsumerGroup consumerGroup, Map<TopicPartition, OffsetAndMetadata> fetchedCurrentOffsets, Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> latestOffsets) {
        ImmutableMap<Partition, Consumer> partitionAssignment = consumerGroup.getPartitionAssignment();
        ConsumerGroupLagSummary.Builder consumerGroupLagSummary = ConsumerGroupLagSummary.builder().setClusterId(clusterId).setConsumerGroupId(consumerGroup.getConsumerGroupId());
        fetchedCurrentOffsets.keySet().forEach(topicPartition -> {
            Optional<Consumer> consumer = Optional.ofNullable((Consumer)partitionAssignment.get(Partition.create(clusterId, topicPartition.topic(), topicPartition.partition(), Collections.emptyList())));
            Optional<Long> currentOffset = ConsumerGroupLagSummaryManagerImpl.getCurrentOffset(fetchedCurrentOffsets, topicPartition);
            Optional<Long> latestOffset = ConsumerGroupLagSummaryManagerImpl.getLatestOffset(latestOffsets, topicPartition);
            if (currentOffset.isPresent() && latestOffset.isPresent()) {
                consumerGroupLagSummary.addOffset(topicPartition.topic(), consumer.map(Consumer::getConsumerId).orElse(""), consumer.flatMap(Consumer::getInstanceId), consumer.map(Consumer::getClientId).orElse(""), topicPartition.partition(), currentOffset.get(), latestOffset.get());
            } else {
                log.debug("missing offset for consumerId={} topic={} partition={} current={} latest={}", new Object[]{consumer.map(Consumer::getConsumerId).orElse(""), topicPartition.topic(), topicPartition.partition(), currentOffset.orElse(null), latestOffset.orElse(null)});
            }
        });
        return consumerGroupLagSummary.build();
    }
}

