/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.common.KafkaFutures;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.entities.Broker;
import io.confluent.kafkarest.entities.Cluster;
import io.confluent.kafkarest.exceptions.UnsupportedProtocolException;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;

final class ClusterManagerImpl
implements ClusterManager {
    private final Admin adminClient;

    @Inject
    ClusterManagerImpl(Admin adminClient) {
        this.adminClient = Objects.requireNonNull(adminClient);
    }

    @Override
    public CompletableFuture<List<Cluster>> listClusters() {
        return this.getLocalCluster().thenApply(cluster -> Collections.unmodifiableList(Collections.singletonList(cluster)));
    }

    @Override
    public CompletableFuture<Optional<Cluster>> getCluster(String clusterId) {
        Objects.requireNonNull(clusterId);
        return this.listClusters().thenApply(clusters -> Entities.findEntityByKey(clusters, Cluster::getClusterId, clusterId));
    }

    @Override
    public CompletableFuture<Cluster> getLocalCluster() {
        DescribeClusterResult describeClusterResult = this.adminClient.describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(false));
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(Cluster.builder()).thenCombine((CompletionStage)KafkaFutures.toCompletableFuture(describeClusterResult.clusterId()), (clusterBuilder, clusterId) -> {
            if (clusterId == null) {
                throw new UnsupportedProtocolException("Metadata Response protocol version >= 2 required.");
            }
            return clusterBuilder.setClusterId((String)clusterId);
        })).thenCombine((CompletionStage)KafkaFutures.toCompletableFuture(describeClusterResult.controller()), (clusterBuilder, controller) -> {
            if (controller == null || controller.isEmpty()) {
                return clusterBuilder;
            }
            return clusterBuilder.setController(Broker.fromNode(clusterBuilder.build().getClusterId(), controller));
        })).thenCombine((CompletionStage)KafkaFutures.toCompletableFuture(describeClusterResult.nodes()), (clusterBuilder, nodes) -> {
            if (nodes == null) {
                return clusterBuilder;
            }
            return clusterBuilder.addAllBrokers(nodes.stream().filter(node -> node != null && !node.isEmpty()).map(node -> Broker.fromNode(clusterBuilder.build().getClusterId(), node)).collect(Collectors.toList()));
        })).thenApply(Cluster.Builder::build);
    }
}

