/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.config;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDeConfig;
import io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy;
import io.confluent.kafkarest.entities.EmbeddedFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.config.ConfigDef;

public final class SchemaRegistryConfig
extends AbstractKafkaSchemaSerDeConfig {
    public static final List<SchemaProvider> SCHEMA_PROVIDERS = Collections.unmodifiableList(Arrays.asList(EmbeddedFormat.AVRO.getSchemaProvider(), EmbeddedFormat.JSONSCHEMA.getSchemaProvider(), EmbeddedFormat.PROTOBUF.getSchemaProvider()));
    private static final ConfigDef CONFIG_DEF = SchemaRegistryConfig.baseConfigDef();

    public SchemaRegistryConfig(Map<String, Object> configs) {
        super(CONFIG_DEF, configs);
    }

    public SubjectNameStrategy getSubjectNameStrategy() {
        return new SubjectNameStrategyImpl(this.keySubjectNameStrategy(), this.valueSubjectNameStrategy());
    }

    private static final class SubjectNameStrategyImpl
    implements SubjectNameStrategy {
        private final SubjectNameStrategy keySubjectNameStrategy;
        private final SubjectNameStrategy valueSubjectNameStrategy;

        private SubjectNameStrategyImpl(SubjectNameStrategy keySubjectNameStrategy, SubjectNameStrategy valueSubjectNameStrategy) {
            this.keySubjectNameStrategy = Objects.requireNonNull(keySubjectNameStrategy);
            this.valueSubjectNameStrategy = Objects.requireNonNull(valueSubjectNameStrategy);
        }

        public String subjectName(String topic, boolean isKey, ParsedSchema schema) {
            if (isKey) {
                return this.keySubjectNameStrategy.subjectName(topic, isKey, schema);
            }
            return this.valueSubjectNameStrategy.subjectName(topic, isKey, schema);
        }

        public void configure(Map<String, ?> configs) {
            this.keySubjectNameStrategy.configure(configs);
            this.valueSubjectNameStrategy.configure(configs);
        }
    }
}

