/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.ClusterConfigManager;
import io.confluent.kafkarest.entities.AbstractConfig;
import io.confluent.kafkarest.entities.ClusterConfig;
import io.confluent.kafkarest.entities.v3.ClusterConfigData;
import io.confluent.kafkarest.entities.v3.ClusterConfigDataList;
import io.confluent.kafkarest.entities.v3.GetClusterConfigResponse;
import io.confluent.kafkarest.entities.v3.ListClusterConfigsResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.entities.v3.UpdateClusterConfigRequest;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;

@Path(value="/v3/clusters/{clusterId}/{config_type}-configs")
@ResourceAccesslistFeature.ResourceName(value="api.v3.cluster-configs.*")
public final class ClusterConfigsResource {
    private final Provider<ClusterConfigManager> clusterConfigManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public ClusterConfigsResource(Provider<ClusterConfigManager> clusterConfigManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.clusterConfigManager = Objects.requireNonNull(clusterConfigManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.clusters.configs.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.cluster-configs.list")
    public void listClusterConfigs(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="config_type") ClusterConfig.Type configType) {
        CompletionStage response = ((ClusterConfigManager)this.clusterConfigManager.get()).listClusterConfigs(clusterId, configType).thenApply(configs -> ListClusterConfigsResponse.create((ClusterConfigDataList)((ClusterConfigDataList.Builder)((ClusterConfigDataList.Builder)ClusterConfigDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", clusterId, String.format("%s-configs", configType.name().toLowerCase()))).build())).setData(configs.stream().sorted(Comparator.comparing(ClusterConfig::getType).thenComparing(AbstractConfig::getName)).map(this::toClusterConfigData).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @GET
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.clusters.configs.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.cluster-configs.get")
    public void getClusterConfig(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="config_type") ClusterConfig.Type configType, @PathParam(value="name") String name) {
        CompletionStage response = ((CompletableFuture)((ClusterConfigManager)this.clusterConfigManager.get()).getClusterConfig(clusterId, configType, name).thenApply(config -> (ClusterConfig)config.orElseThrow(NotFoundException::new))).thenApply(config -> GetClusterConfigResponse.create(this.toClusterConfigData((ClusterConfig)config)));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @PUT
    @Path(value="/{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.clusters.configs.update")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.cluster-configs.update")
    public void upsertClusterConfig(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="config_type") ClusterConfig.Type configType, @PathParam(value="name") String name, @Valid UpdateClusterConfigRequest request) {
        String newValue = request.getValue().orElse(null);
        CompletableFuture<Void> response = ((ClusterConfigManager)this.clusterConfigManager.get()).upsertClusterConfig(clusterId, configType, name, newValue);
        AsyncResponses.AsyncResponseBuilder.from(Response.status((Response.Status)Response.Status.NO_CONTENT)).entity(response).asyncResume(asyncResponse);
    }

    @DELETE
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.clusters.configs.delete")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.cluster-configs.delete")
    public void deleteClusterConfig(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="config_type") ClusterConfig.Type configType, @PathParam(value="name") String name) {
        CompletableFuture<Void> response = ((ClusterConfigManager)this.clusterConfigManager.get()).deleteClusterConfig(clusterId, configType, name);
        AsyncResponses.AsyncResponseBuilder.from(Response.status((Response.Status)Response.Status.NO_CONTENT)).entity(response).asyncResume(asyncResponse);
    }

    private ClusterConfigData toClusterConfigData(ClusterConfig clusterConfig) {
        return ((ClusterConfigData.Builder)ClusterConfigData.fromClusterConfig(clusterConfig).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", clusterConfig.getClusterId(), String.format("%s-configs", clusterConfig.getType().name().toLowerCase()), clusterConfig.getName())).setResourceName(this.crnFactory.create("kafka", clusterConfig.getClusterId(), String.format("%s-config", clusterConfig.getType().name().toLowerCase()), clusterConfig.getName())).build())).build();
    }
}

