/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.ratelimit;

import io.confluent.kafkarest.ratelimit.RateLimitExceededException;
import io.confluent.kafkarest.ratelimit.RequestRateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import java.time.Duration;
import java.util.Objects;

final class Resilience4JRateLimiter
extends RequestRateLimiter {
    private final RateLimiter delegate;

    private Resilience4JRateLimiter(RateLimiter delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    static Resilience4JRateLimiter create(int permitsPerSecond, Duration timeout) {
        RateLimiterConfig config = RateLimiterConfig.custom().timeoutDuration(timeout).limitRefreshPeriod(Duration.ofSeconds(1L)).limitForPeriod(permitsPerSecond).build();
        return new Resilience4JRateLimiter(RateLimiter.of((String)"Resilience4JRateLimiter", (RateLimiterConfig)config));
    }

    @Override
    public void rateLimit(int cost) {
        if (!this.delegate.acquirePermission(cost)) {
            throw new RateLimitExceededException();
        }
    }
}

