/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.extension;

import io.confluent.kafkarest.config.ConfigModule;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.wadl.processor.OptionsMethodProcessor;

public final class ResourceAccesslistFeature
implements DynamicFeature {
    private final Set<String> apiEndpointsBlocklistConfig;
    private final Set<String> apiEndpointsAllowlistConfig;

    @Inject
    ResourceAccesslistFeature(@ConfigModule.ApiEndpointsAllowlistConfig Set<String> apiEndpointsAllowlistConfig, @ConfigModule.ApiEndpointsBlocklistConfig Set<String> apiEndpointsBlocklistConfig) {
        this.apiEndpointsAllowlistConfig = Objects.requireNonNull(apiEndpointsAllowlistConfig);
        this.apiEndpointsBlocklistConfig = Objects.requireNonNull(apiEndpointsBlocklistConfig);
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        boolean blocked;
        if (ResourceAccesslistFeature.isOptionsProcessor(resourceInfo)) {
            return;
        }
        boolean bl = blocked = this.isBlockedByAccesslist(resourceInfo, this.apiEndpointsAllowlistConfig, true) || this.isBlockedByAccesslist(resourceInfo, this.apiEndpointsBlocklistConfig, false);
        if (blocked) {
            context.register(ThrowingFilter.class);
        }
    }

    private static boolean isOptionsProcessor(ResourceInfo resourceInfo) {
        return resourceInfo.getResourceClass() != null && resourceInfo.getResourceClass().getEnclosingClass() != null && resourceInfo.getResourceClass().getEnclosingClass().equals(OptionsMethodProcessor.class);
    }

    private boolean isBlockedByAccesslist(ResourceInfo resourceInfo, Set<String> accesslist, boolean isAccesslistAllowlist) {
        ResourceName resourceMethodName;
        if (accesslist.isEmpty()) {
            return false;
        }
        boolean blocked = isAccesslistAllowlist;
        ResourceName resourceClassName = resourceInfo.getResourceClass().getAnnotation(ResourceName.class);
        if (resourceClassName != null && accesslist.contains(resourceClassName.value())) {
            boolean bl = blocked = !isAccesslistAllowlist;
        }
        if ((resourceMethodName = resourceInfo.getResourceMethod().getAnnotation(ResourceName.class)) != null && accesslist.contains(resourceMethodName.value())) {
            blocked = !isAccesslistAllowlist;
        }
        return blocked;
    }

    @Priority(value=500)
    private static final class ThrowingFilter
    implements ContainerRequestFilter {
        private ThrowingFilter() {
        }

        public void filter(ContainerRequestContext context) {
            if ("GET".equals(context.getMethod())) {
                throw new NotFoundException();
            }
            throw new NotAllowedException(Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build());
        }
    }

    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ResourceName {
        public String value();
    }
}

