/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.ReplicaData;
import io.confluent.kafkarest.entities.v3.ReplicaDataList;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import java.util.List;

final class AutoValue_ReplicaDataList
extends ReplicaDataList {
    private final String kind;
    private final ResourceCollection.Metadata metadata;
    private final ImmutableList<ReplicaData> data;

    private AutoValue_ReplicaDataList(String kind, ResourceCollection.Metadata metadata, ImmutableList<ReplicaData> data) {
        this.kind = kind;
        this.metadata = metadata;
        this.data = data;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ResourceCollection.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="data")
    public ImmutableList<ReplicaData> getData() {
        return this.data;
    }

    public String toString() {
        return "ReplicaDataList{kind=" + this.kind + ", metadata=" + this.metadata + ", data=" + this.data + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ReplicaDataList) {
            ReplicaDataList that = (ReplicaDataList)o;
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.data.equals(that.getData());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        return h$ ^= this.data.hashCode();
    }

    static final class Builder
    extends ReplicaDataList.Builder {
        private String kind;
        private ResourceCollection.Metadata metadata;
        private ImmutableList<ReplicaData> data;

        Builder() {
        }

        @Override
        public ReplicaDataList.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        @Override
        public ReplicaDataList.Builder setMetadata(ResourceCollection.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public ReplicaDataList.Builder setData(List<ReplicaData> data) {
            this.data = ImmutableList.copyOf(data);
            return this;
        }

        @Override
        public ReplicaDataList build() {
            String missing = "";
            if (this.kind == null) {
                missing = missing + " kind";
            }
            if (this.metadata == null) {
                missing = missing + " metadata";
            }
            if (this.data == null) {
                missing = missing + " data";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ReplicaDataList(this.kind, this.metadata, this.data);
        }
    }
}

