/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.ReassignmentData;
import io.confluent.kafkarest.entities.v3.Resource;
import java.util.List;

final class AutoValue_ReassignmentData
extends ReassignmentData {
    private final String kind;
    private final Resource.Metadata metadata;
    private final String clusterId;
    private final String topicName;
    private final int partitionId;
    private final ImmutableList<Integer> addingReplicas;
    private final ImmutableList<Integer> removingReplicas;
    private final Resource.Relationship replicas;

    private AutoValue_ReassignmentData(String kind, Resource.Metadata metadata, String clusterId, String topicName, int partitionId, ImmutableList<Integer> addingReplicas, ImmutableList<Integer> removingReplicas, Resource.Relationship replicas) {
        this.kind = kind;
        this.metadata = metadata;
        this.clusterId = clusterId;
        this.topicName = topicName;
        this.partitionId = partitionId;
        this.addingReplicas = addingReplicas;
        this.removingReplicas = removingReplicas;
        this.replicas = replicas;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public Resource.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="cluster_id")
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    @JsonProperty(value="topic_name")
    public String getTopicName() {
        return this.topicName;
    }

    @Override
    @JsonProperty(value="partition_id")
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    @JsonProperty(value="adding_replicas")
    public ImmutableList<Integer> getAddingReplicas() {
        return this.addingReplicas;
    }

    @Override
    @JsonProperty(value="removing_replicas")
    public ImmutableList<Integer> getRemovingReplicas() {
        return this.removingReplicas;
    }

    @Override
    @JsonProperty(value="replicas")
    public Resource.Relationship getReplicas() {
        return this.replicas;
    }

    public String toString() {
        return "ReassignmentData{kind=" + this.kind + ", metadata=" + this.metadata + ", clusterId=" + this.clusterId + ", topicName=" + this.topicName + ", partitionId=" + this.partitionId + ", addingReplicas=" + this.addingReplicas + ", removingReplicas=" + this.removingReplicas + ", replicas=" + this.replicas + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ReassignmentData) {
            ReassignmentData that = (ReassignmentData)o;
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.clusterId.equals(that.getClusterId()) && this.topicName.equals(that.getTopicName()) && this.partitionId == that.getPartitionId() && this.addingReplicas.equals(that.getAddingReplicas()) && this.removingReplicas.equals(that.getRemovingReplicas()) && this.replicas.equals(that.getReplicas());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.topicName.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitionId;
        h$ *= 1000003;
        h$ ^= this.addingReplicas.hashCode();
        h$ *= 1000003;
        h$ ^= this.removingReplicas.hashCode();
        h$ *= 1000003;
        return h$ ^= this.replicas.hashCode();
    }

    static final class Builder
    extends ReassignmentData.Builder {
        private String kind;
        private Resource.Metadata metadata;
        private String clusterId;
        private String topicName;
        private Integer partitionId;
        private ImmutableList<Integer> addingReplicas;
        private ImmutableList<Integer> removingReplicas;
        private Resource.Relationship replicas;

        Builder() {
        }

        @Override
        public ReassignmentData.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        @Override
        public ReassignmentData.Builder setMetadata(Resource.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public ReassignmentData.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public ReassignmentData.Builder setTopicName(String topicName) {
            if (topicName == null) {
                throw new NullPointerException("Null topicName");
            }
            this.topicName = topicName;
            return this;
        }

        @Override
        public ReassignmentData.Builder setPartitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        @Override
        public ReassignmentData.Builder setAddingReplicas(List<Integer> addingReplicas) {
            this.addingReplicas = ImmutableList.copyOf(addingReplicas);
            return this;
        }

        @Override
        public ReassignmentData.Builder setRemovingReplicas(List<Integer> removingReplicas) {
            this.removingReplicas = ImmutableList.copyOf(removingReplicas);
            return this;
        }

        @Override
        public ReassignmentData.Builder setReplicas(Resource.Relationship replicas) {
            if (replicas == null) {
                throw new NullPointerException("Null replicas");
            }
            this.replicas = replicas;
            return this;
        }

        @Override
        public ReassignmentData build() {
            String missing = "";
            if (this.kind == null) {
                missing = missing + " kind";
            }
            if (this.metadata == null) {
                missing = missing + " metadata";
            }
            if (this.clusterId == null) {
                missing = missing + " clusterId";
            }
            if (this.topicName == null) {
                missing = missing + " topicName";
            }
            if (this.partitionId == null) {
                missing = missing + " partitionId";
            }
            if (this.addingReplicas == null) {
                missing = missing + " addingReplicas";
            }
            if (this.removingReplicas == null) {
                missing = missing + " removingReplicas";
            }
            if (this.replicas == null) {
                missing = missing + " replicas";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ReassignmentData(this.kind, this.metadata, this.clusterId, this.topicName, this.partitionId, this.addingReplicas, this.removingReplicas, this.replicas);
        }
    }
}

