/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.v3.PartitionData;
import io.confluent.kafkarest.entities.v3.Resource;
import java.util.Optional;
import javax.annotation.Nullable;

final class AutoValue_PartitionData
extends PartitionData {
    private final String kind;
    private final Resource.Metadata metadata;
    private final String clusterId;
    private final String topicName;
    private final int partitionId;
    private final Optional<Resource.Relationship> leader;
    private final Resource.Relationship replicas;
    private final Resource.Relationship reassignment;

    private AutoValue_PartitionData(String kind, Resource.Metadata metadata, String clusterId, String topicName, int partitionId, Optional<Resource.Relationship> leader, Resource.Relationship replicas, Resource.Relationship reassignment) {
        this.kind = kind;
        this.metadata = metadata;
        this.clusterId = clusterId;
        this.topicName = topicName;
        this.partitionId = partitionId;
        this.leader = leader;
        this.replicas = replicas;
        this.reassignment = reassignment;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public Resource.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="cluster_id")
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    @JsonProperty(value="topic_name")
    public String getTopicName() {
        return this.topicName;
    }

    @Override
    @JsonProperty(value="partition_id")
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    @JsonProperty(value="leader")
    public Optional<Resource.Relationship> getLeader() {
        return this.leader;
    }

    @Override
    @JsonProperty(value="replicas")
    public Resource.Relationship getReplicas() {
        return this.replicas;
    }

    @Override
    @JsonProperty(value="reassignment")
    public Resource.Relationship getReassignment() {
        return this.reassignment;
    }

    public String toString() {
        return "PartitionData{kind=" + this.kind + ", metadata=" + this.metadata + ", clusterId=" + this.clusterId + ", topicName=" + this.topicName + ", partitionId=" + this.partitionId + ", leader=" + this.leader + ", replicas=" + this.replicas + ", reassignment=" + this.reassignment + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PartitionData) {
            PartitionData that = (PartitionData)o;
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.clusterId.equals(that.getClusterId()) && this.topicName.equals(that.getTopicName()) && this.partitionId == that.getPartitionId() && this.leader.equals(that.getLeader()) && this.replicas.equals(that.getReplicas()) && this.reassignment.equals(that.getReassignment());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.topicName.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitionId;
        h$ *= 1000003;
        h$ ^= this.leader.hashCode();
        h$ *= 1000003;
        h$ ^= this.replicas.hashCode();
        h$ *= 1000003;
        return h$ ^= this.reassignment.hashCode();
    }

    static final class Builder
    extends PartitionData.Builder {
        private String kind;
        private Resource.Metadata metadata;
        private String clusterId;
        private String topicName;
        private Integer partitionId;
        private Optional<Resource.Relationship> leader = Optional.empty();
        private Resource.Relationship replicas;
        private Resource.Relationship reassignment;

        Builder() {
        }

        @Override
        public PartitionData.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        @Override
        public PartitionData.Builder setMetadata(Resource.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public PartitionData.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public PartitionData.Builder setTopicName(String topicName) {
            if (topicName == null) {
                throw new NullPointerException("Null topicName");
            }
            this.topicName = topicName;
            return this;
        }

        @Override
        public PartitionData.Builder setPartitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        @Override
        public PartitionData.Builder setLeader(@Nullable Resource.Relationship leader) {
            this.leader = Optional.ofNullable(leader);
            return this;
        }

        @Override
        public PartitionData.Builder setReplicas(Resource.Relationship replicas) {
            if (replicas == null) {
                throw new NullPointerException("Null replicas");
            }
            this.replicas = replicas;
            return this;
        }

        @Override
        public PartitionData.Builder setReassignment(Resource.Relationship reassignment) {
            if (reassignment == null) {
                throw new NullPointerException("Null reassignment");
            }
            this.reassignment = reassignment;
            return this;
        }

        @Override
        public PartitionData build() {
            String missing = "";
            if (this.kind == null) {
                missing = missing + " kind";
            }
            if (this.metadata == null) {
                missing = missing + " metadata";
            }
            if (this.clusterId == null) {
                missing = missing + " clusterId";
            }
            if (this.topicName == null) {
                missing = missing + " topicName";
            }
            if (this.partitionId == null) {
                missing = missing + " partitionId";
            }
            if (this.replicas == null) {
                missing = missing + " replicas";
            }
            if (this.reassignment == null) {
                missing = missing + " reassignment";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PartitionData(this.kind, this.metadata, this.clusterId, this.topicName, this.partitionId, this.leader, this.replicas, this.reassignment);
        }
    }
}

