/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.v3.ConsumerLagData;
import io.confluent.kafkarest.entities.v3.Resource;
import java.util.Optional;
import javax.annotation.Nullable;

final class AutoValue_ConsumerLagData
extends ConsumerLagData {
    private final String kind;
    private final Resource.Metadata metadata;
    private final String clusterId;
    private final String consumerGroupId;
    private final String topicName;
    private final int partitionId;
    private final String consumerId;
    private final Optional<String> instanceId;
    private final String clientId;
    private final Long currentOffset;
    private final Long logEndOffset;
    private final Long lag;

    private AutoValue_ConsumerLagData(String kind, Resource.Metadata metadata, String clusterId, String consumerGroupId, String topicName, int partitionId, String consumerId, Optional<String> instanceId, String clientId, Long currentOffset, Long logEndOffset, Long lag) {
        this.kind = kind;
        this.metadata = metadata;
        this.clusterId = clusterId;
        this.consumerGroupId = consumerGroupId;
        this.topicName = topicName;
        this.partitionId = partitionId;
        this.consumerId = consumerId;
        this.instanceId = instanceId;
        this.clientId = clientId;
        this.currentOffset = currentOffset;
        this.logEndOffset = logEndOffset;
        this.lag = lag;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public Resource.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="cluster_id")
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    @JsonProperty(value="consumer_group_id")
    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    @Override
    @JsonProperty(value="topic_name")
    public String getTopicName() {
        return this.topicName;
    }

    @Override
    @JsonProperty(value="partition_id")
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    @JsonProperty(value="consumer_id")
    public String getConsumerId() {
        return this.consumerId;
    }

    @Override
    @JsonProperty(value="instance_id")
    public Optional<String> getInstanceId() {
        return this.instanceId;
    }

    @Override
    @JsonProperty(value="client_id")
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @JsonProperty(value="current_offset")
    public Long getCurrentOffset() {
        return this.currentOffset;
    }

    @Override
    @JsonProperty(value="log_end_offset")
    public Long getLogEndOffset() {
        return this.logEndOffset;
    }

    @Override
    @JsonProperty(value="lag")
    public Long getLag() {
        return this.lag;
    }

    public String toString() {
        return "ConsumerLagData{kind=" + this.kind + ", metadata=" + this.metadata + ", clusterId=" + this.clusterId + ", consumerGroupId=" + this.consumerGroupId + ", topicName=" + this.topicName + ", partitionId=" + this.partitionId + ", consumerId=" + this.consumerId + ", instanceId=" + this.instanceId + ", clientId=" + this.clientId + ", currentOffset=" + this.currentOffset + ", logEndOffset=" + this.logEndOffset + ", lag=" + this.lag + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ConsumerLagData) {
            ConsumerLagData that = (ConsumerLagData)o;
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.clusterId.equals(that.getClusterId()) && this.consumerGroupId.equals(that.getConsumerGroupId()) && this.topicName.equals(that.getTopicName()) && this.partitionId == that.getPartitionId() && this.consumerId.equals(that.getConsumerId()) && this.instanceId.equals(that.getInstanceId()) && this.clientId.equals(that.getClientId()) && this.currentOffset.equals(that.getCurrentOffset()) && this.logEndOffset.equals(that.getLogEndOffset()) && this.lag.equals(that.getLag());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.consumerGroupId.hashCode();
        h$ *= 1000003;
        h$ ^= this.topicName.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitionId;
        h$ *= 1000003;
        h$ ^= this.consumerId.hashCode();
        h$ *= 1000003;
        h$ ^= this.instanceId.hashCode();
        h$ *= 1000003;
        h$ ^= this.clientId.hashCode();
        h$ *= 1000003;
        h$ ^= this.currentOffset.hashCode();
        h$ *= 1000003;
        h$ ^= this.logEndOffset.hashCode();
        h$ *= 1000003;
        return h$ ^= this.lag.hashCode();
    }

    static final class Builder
    extends ConsumerLagData.Builder {
        private String kind;
        private Resource.Metadata metadata;
        private String clusterId;
        private String consumerGroupId;
        private String topicName;
        private Integer partitionId;
        private String consumerId;
        private Optional<String> instanceId = Optional.empty();
        private String clientId;
        private Long currentOffset;
        private Long logEndOffset;
        private Long lag;

        Builder() {
        }

        @Override
        public ConsumerLagData.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        @Override
        public ConsumerLagData.Builder setMetadata(Resource.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public ConsumerLagData.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public ConsumerLagData.Builder setConsumerGroupId(String consumerGroupId) {
            if (consumerGroupId == null) {
                throw new NullPointerException("Null consumerGroupId");
            }
            this.consumerGroupId = consumerGroupId;
            return this;
        }

        @Override
        public ConsumerLagData.Builder setTopicName(String topicName) {
            if (topicName == null) {
                throw new NullPointerException("Null topicName");
            }
            this.topicName = topicName;
            return this;
        }

        @Override
        public ConsumerLagData.Builder setPartitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        @Override
        public ConsumerLagData.Builder setConsumerId(String consumerId) {
            if (consumerId == null) {
                throw new NullPointerException("Null consumerId");
            }
            this.consumerId = consumerId;
            return this;
        }

        @Override
        public ConsumerLagData.Builder setInstanceId(@Nullable String instanceId) {
            this.instanceId = Optional.ofNullable(instanceId);
            return this;
        }

        @Override
        public ConsumerLagData.Builder setClientId(String clientId) {
            if (clientId == null) {
                throw new NullPointerException("Null clientId");
            }
            this.clientId = clientId;
            return this;
        }

        @Override
        public ConsumerLagData.Builder setCurrentOffset(Long currentOffset) {
            if (currentOffset == null) {
                throw new NullPointerException("Null currentOffset");
            }
            this.currentOffset = currentOffset;
            return this;
        }

        @Override
        public ConsumerLagData.Builder setLogEndOffset(Long logEndOffset) {
            if (logEndOffset == null) {
                throw new NullPointerException("Null logEndOffset");
            }
            this.logEndOffset = logEndOffset;
            return this;
        }

        @Override
        public ConsumerLagData.Builder setLag(Long lag) {
            if (lag == null) {
                throw new NullPointerException("Null lag");
            }
            this.lag = lag;
            return this;
        }

        @Override
        public ConsumerLagData build() {
            String missing = "";
            if (this.kind == null) {
                missing = missing + " kind";
            }
            if (this.metadata == null) {
                missing = missing + " metadata";
            }
            if (this.clusterId == null) {
                missing = missing + " clusterId";
            }
            if (this.consumerGroupId == null) {
                missing = missing + " consumerGroupId";
            }
            if (this.topicName == null) {
                missing = missing + " topicName";
            }
            if (this.partitionId == null) {
                missing = missing + " partitionId";
            }
            if (this.consumerId == null) {
                missing = missing + " consumerId";
            }
            if (this.clientId == null) {
                missing = missing + " clientId";
            }
            if (this.currentOffset == null) {
                missing = missing + " currentOffset";
            }
            if (this.logEndOffset == null) {
                missing = missing + " logEndOffset";
            }
            if (this.lag == null) {
                missing = missing + " lag";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ConsumerLagData(this.kind, this.metadata, this.clusterId, this.consumerGroupId, this.topicName, this.partitionId, this.consumerId, this.instanceId, this.clientId, this.currentOffset, this.logEndOffset, this.lag);
        }
    }
}

