/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.v2.PartitionOffset;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import javax.validation.constraints.NotEmpty;
import javax.ws.rs.core.Response;

public final class ProduceResponse {
    @NotEmpty
    @Nullable
    private final List<PartitionOffset> offsets;
    @Nullable
    private final Integer keySchemaId;
    @Nullable
    private final Integer valueSchemaId;

    @JsonCreator
    public ProduceResponse(@JsonProperty(value="offsets") @Nullable List<PartitionOffset> offsets, @JsonProperty(value="key_schema_id") @Nullable Integer keySchemaId, @JsonProperty(value="value_schema_id") @Nullable Integer valueSchemaId) {
        this.offsets = offsets;
        this.keySchemaId = keySchemaId;
        this.valueSchemaId = valueSchemaId;
    }

    @JsonProperty
    @Nullable
    public List<PartitionOffset> getOffsets() {
        return this.offsets;
    }

    @JsonProperty(value="key_schema_id")
    @Nullable
    public Integer getKeySchemaId() {
        return this.keySchemaId;
    }

    @JsonProperty(value="value_schema_id")
    @Nullable
    public Integer getValueSchemaId() {
        return this.valueSchemaId;
    }

    @JsonIgnore
    public Response.Status getRequestStatus() {
        for (PartitionOffset partitionOffset : this.offsets) {
            if (partitionOffset.getErrorCode() == null) continue;
            if (partitionOffset.getErrorCode() == 40101) {
                return Response.Status.UNAUTHORIZED;
            }
            if (partitionOffset.getErrorCode() != 40301) continue;
            return Response.Status.FORBIDDEN;
        }
        return Response.Status.OK;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProduceResponse that = (ProduceResponse)o;
        return Objects.equals(this.offsets, that.offsets) && Objects.equals(this.keySchemaId, that.keySchemaId) && Objects.equals(this.valueSchemaId, that.valueSchemaId);
    }

    public int hashCode() {
        return Objects.hash(this.offsets, this.keySchemaId, this.valueSchemaId);
    }

    public String toString() {
        return new StringJoiner(", ", ProduceResponse.class.getSimpleName() + "[", "]").add("offsets=" + this.offsets).add("keySchemaId=" + this.keySchemaId).add("valueSchemaId=" + this.valueSchemaId).toString();
    }
}

