/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import io.confluent.kafkarest.entities.ProduceResult;
import java.time.Instant;
import java.util.Optional;

final class AutoValue_ProduceResult
extends ProduceResult {
    private final int partitionId;
    private final long offset;
    private final Optional<Instant> timestamp;
    private final int serializedKeySize;
    private final int serializedValueSize;
    private final Instant completionTimestamp;

    AutoValue_ProduceResult(int partitionId, long offset, Optional<Instant> timestamp, int serializedKeySize, int serializedValueSize, Instant completionTimestamp) {
        this.partitionId = partitionId;
        this.offset = offset;
        if (timestamp == null) {
            throw new NullPointerException("Null timestamp");
        }
        this.timestamp = timestamp;
        this.serializedKeySize = serializedKeySize;
        this.serializedValueSize = serializedValueSize;
        if (completionTimestamp == null) {
            throw new NullPointerException("Null completionTimestamp");
        }
        this.completionTimestamp = completionTimestamp;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public Optional<Instant> getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int getSerializedKeySize() {
        return this.serializedKeySize;
    }

    @Override
    public int getSerializedValueSize() {
        return this.serializedValueSize;
    }

    @Override
    public Instant getCompletionTimestamp() {
        return this.completionTimestamp;
    }

    public String toString() {
        return "ProduceResult{partitionId=" + this.partitionId + ", offset=" + this.offset + ", timestamp=" + this.timestamp + ", serializedKeySize=" + this.serializedKeySize + ", serializedValueSize=" + this.serializedValueSize + ", completionTimestamp=" + this.completionTimestamp + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProduceResult) {
            ProduceResult that = (ProduceResult)o;
            return this.partitionId == that.getPartitionId() && this.offset == that.getOffset() && this.timestamp.equals(that.getTimestamp()) && this.serializedKeySize == that.getSerializedKeySize() && this.serializedValueSize == that.getSerializedValueSize() && this.completionTimestamp.equals(that.getCompletionTimestamp());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.partitionId;
        h$ *= 1000003;
        h$ ^= (int)(this.offset >>> 32 ^ this.offset);
        h$ *= 1000003;
        h$ ^= this.timestamp.hashCode();
        h$ *= 1000003;
        h$ ^= this.serializedKeySize;
        h$ *= 1000003;
        h$ ^= this.serializedValueSize;
        h$ *= 1000003;
        return h$ ^= this.completionTimestamp.hashCode();
    }
}

