/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.protobuf.ByteString;
import io.confluent.kafkarest.controllers.NoSchemaRecordSerializer;
import io.confluent.kafkarest.controllers.RecordSerializer;
import io.confluent.kafkarest.controllers.SchemaRecordSerializer;
import io.confluent.kafkarest.entities.EmbeddedFormat;
import io.confluent.kafkarest.entities.RegisteredSchema;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;

final class RecordSerializerFacade
implements RecordSerializer {
    private final NoSchemaRecordSerializer noSchemaRecordSerializer;
    private final Provider<SchemaRecordSerializer> schemaRecordSerializerProvider;

    @Inject
    RecordSerializerFacade(NoSchemaRecordSerializer noSchemaRecordSerializer, Provider<SchemaRecordSerializer> schemaRecordSerializerProvider) {
        this.noSchemaRecordSerializer = Objects.requireNonNull(noSchemaRecordSerializer);
        this.schemaRecordSerializerProvider = Objects.requireNonNull(schemaRecordSerializerProvider);
    }

    @Override
    public Optional<ByteString> serialize(EmbeddedFormat format, String topicName, Optional<RegisteredSchema> schema, JsonNode data, boolean isKey) {
        if (format.requiresSchema()) {
            return ((SchemaRecordSerializer)this.schemaRecordSerializerProvider.get()).serialize(format, topicName, schema, data, isKey);
        }
        return this.noSchemaRecordSerializer.serialize(format, data);
    }
}

