/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import com.google.common.collect.Multimap;
import com.google.protobuf.ByteString;
import io.confluent.kafkarest.controllers.ProduceController;
import io.confluent.kafkarest.entities.ProduceResult;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProduceControllerImpl
implements ProduceController {
    private static final Logger log = LoggerFactory.getLogger(ProduceController.class);
    private final Producer<byte[], byte[]> producer;

    @Inject
    ProduceControllerImpl(Producer<byte[], byte[]> producer) {
        this.producer = Objects.requireNonNull(producer);
    }

    @Override
    public CompletableFuture<ProduceResult> produce(String clusterId, String topicName, Optional<Integer> partitionId, Multimap<String, Optional<ByteString>> headers, Optional<ByteString> key, Optional<ByteString> value, Instant timestamp) {
        CompletableFuture<ProduceResult> result = new CompletableFuture<ProduceResult>();
        log.debug("Producing to kafka");
        this.producer.send(new ProducerRecord(topicName, (Integer)partitionId.orElse(null), Long.valueOf(timestamp.toEpochMilli()), key.map(ByteString::toByteArray).orElse(null), value.map(ByteString::toByteArray).orElse(null), (Iterable)headers.entries().stream().map(header -> new RecordHeader((String)header.getKey(), (byte[])((Optional)header.getValue()).map(ByteString::toByteArray).orElse(null))).collect(Collectors.toList())), (metadata, exception) -> {
            if (exception != null) {
                log.debug("Received exception from kafka", (Throwable)exception);
                result.completeExceptionally(exception);
            } else {
                log.debug("Received response from kafka");
                result.complete(ProduceResult.fromRecordMetadata(metadata, Instant.now()));
            }
        });
        return result;
    }
}

