/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.controllers.BrokerManager;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.entities.Broker;
import io.confluent.kafkarest.entities.Cluster;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;

final class BrokerManagerImpl
implements BrokerManager {
    private final ClusterManager clusterManager;

    @Inject
    BrokerManagerImpl(ClusterManager clusterManager) {
        this.clusterManager = Objects.requireNonNull(clusterManager);
    }

    @Override
    public CompletableFuture<List<Broker>> listBrokers(String clusterId) {
        return ((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists(cluster, "Cluster %s cannot be found.", clusterId))).thenApply(Cluster::getBrokers);
    }

    @Override
    public CompletableFuture<Optional<Broker>> getBroker(String clusterId, int brokerId) {
        return this.listBrokers(clusterId).thenApply(brokers -> Entities.findEntityByKey(brokers, Broker::getBrokerId, brokerId));
    }

    @Override
    public CompletableFuture<List<Broker>> listLocalBrokers() {
        return this.clusterManager.getLocalCluster().thenApply(Cluster::getBrokers);
    }
}

