/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafkarest.ConsumerInstanceId;
import io.confluent.kafkarest.ConsumerRecordAndSize;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.entities.ConsumerInstanceConfig;
import io.confluent.kafkarest.entities.ConsumerRecord;
import io.confluent.kafkarest.v2.KafkaConsumerState;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.errors.SerializationException;

public class JsonKafkaConsumerState
extends KafkaConsumerState<byte[], byte[], Object, Object> {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public JsonKafkaConsumerState(KafkaRestConfig config, ConsumerInstanceConfig consumerInstanceConfig, ConsumerInstanceId instanceId, Consumer consumer) {
        super(config, consumerInstanceConfig, instanceId, consumer);
    }

    @Override
    public ConsumerRecordAndSize<Object, Object> createConsumerRecord(org.apache.kafka.clients.consumer.ConsumerRecord<byte[], byte[]> record) {
        long approxSize = 0L;
        Object key = null;
        Object value = null;
        if (record.key() != null) {
            approxSize += (long)((byte[])record.key()).length;
            key = this.deserialize((byte[])record.key());
        }
        if (record.value() != null) {
            approxSize += (long)((byte[])record.value()).length;
            value = this.deserialize((byte[])record.value());
        }
        return new ConsumerRecordAndSize<Object, Object>(ConsumerRecord.create(record.topic(), key, value, record.partition(), record.offset()), approxSize);
    }

    private Object deserialize(byte[] data) {
        try {
            return objectMapper.readValue(data, Object.class);
        }
        catch (Exception e) {
            throw new SerializationException((Throwable)e);
        }
    }
}

