/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.TopicManager;
import io.confluent.kafkarest.entities.Topic;
import io.confluent.kafkarest.entities.v3.CreateTopicRequest;
import io.confluent.kafkarest.entities.v3.CreateTopicResponse;
import io.confluent.kafkarest.entities.v3.GetTopicResponse;
import io.confluent.kafkarest.entities.v3.ListTopicsResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.entities.v3.TopicData;
import io.confluent.kafkarest.entities.v3.TopicDataList;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;

@Path(value="/v3/clusters/{clusterId}/topics")
@ResourceAccesslistFeature.ResourceName(value="api.v3.topics.*")
public final class TopicsResource {
    private final Provider<TopicManager> topicManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public TopicsResource(Provider<TopicManager> topicManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.topicManager = Objects.requireNonNull(topicManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.topics.list")
    public void listTopics(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId) {
        CompletionStage response = ((TopicManager)this.topicManager.get()).listTopics(clusterId).thenApply(topics -> ListTopicsResponse.create((TopicDataList)((TopicDataList.Builder)((TopicDataList.Builder)TopicDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", clusterId, "topics")).build())).setData(topics.stream().sorted(Comparator.comparing(Topic::getName)).map(this::toTopicData).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @GET
    @Path(value="/{topicName}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.topics.get")
    public void getTopic(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName) {
        CompletionStage response = ((CompletableFuture)((TopicManager)this.topicManager.get()).getTopic(clusterId, topicName).thenApply(topic -> (Topic)topic.orElseThrow(NotFoundException::new))).thenApply(topic -> GetTopicResponse.create(this.toTopicData((Topic)topic)));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.create")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.topics.create")
    public void createTopic(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @Valid CreateTopicRequest request) {
        String topicName = request.getTopicName();
        Optional<Integer> partitionsCount = request.getPartitionsCount();
        Optional<Short> replicationFactor = request.getReplicationFactor();
        Map<Integer, List<Integer>> replicasAssignments = request.getReplicasAssignments();
        Map<String, Optional<String>> configs = request.getConfigs().stream().collect(Collectors.toMap(CreateTopicRequest.ConfigEntry::getName, CreateTopicRequest.ConfigEntry::getValue));
        short assumedReplicationFactor = replicationFactor.orElse(replicasAssignments.isEmpty() ? (short)0 : (short)replicasAssignments.values().iterator().next().size());
        TopicData topicData = this.toTopicData(Topic.create(clusterId, topicName, Collections.emptyList(), assumedReplicationFactor, false));
        CompletionStage response = ((TopicManager)this.topicManager.get()).createTopic(clusterId, topicName, partitionsCount, replicationFactor, replicasAssignments, configs).thenApply(none -> CreateTopicResponse.create(topicData));
        AsyncResponses.AsyncResponseBuilder.from(Response.status((Response.Status)Response.Status.CREATED).location(URI.create(topicData.getMetadata().getSelf()))).entity(response).asyncResume(asyncResponse);
    }

    @DELETE
    @Path(value="/{topicName}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.delete")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.topics.delete")
    public void deleteTopic(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName) {
        CompletableFuture<Void> response = ((TopicManager)this.topicManager.get()).deleteTopic(clusterId, topicName);
        AsyncResponses.AsyncResponseBuilder.from(Response.status((Response.Status)Response.Status.NO_CONTENT)).entity(response).asyncResume(asyncResponse);
    }

    private TopicData toTopicData(Topic topic) {
        return ((TopicData.Builder)TopicData.fromTopic(topic).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", topic.getClusterId(), "topics", topic.getName())).setResourceName(this.crnFactory.create("kafka", topic.getClusterId(), "topic", topic.getName())).build())).setPartitions(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", topic.getClusterId(), "topics", topic.getName(), "partitions"))).setConfigs(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", topic.getClusterId(), "topics", topic.getName(), "configs"))).setPartitionReassignments(Resource.Relationship.create(this.urlFactory.create("v3", "clusters", topic.getClusterId(), "topics", topic.getName(), "partitions", "-", "reassignment"))).build();
    }
}

