/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.BrokerConfigManager;
import io.confluent.kafkarest.entities.v3.AlterBrokerConfigBatchRequest;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;

@Path(value="/v3/clusters/{clusterId}/brokers/{brokerId}/configs:alter")
@ResourceAccesslistFeature.ResourceName(value="api.v3.broker-configs.*")
public final class AlterBrokerConfigBatchAction {
    private final Provider<BrokerConfigManager> brokerConfigManager;

    @Inject
    public AlterBrokerConfigBatchAction(Provider<BrokerConfigManager> brokerConfigManager) {
        this.brokerConfigManager = Objects.requireNonNull(brokerConfigManager);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.brokers.configs.alter")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.broker-configs.alter")
    public void alterBrokerConfigBatch(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="brokerId") int brokerId, @Valid AlterBrokerConfigBatchRequest request) {
        CompletableFuture<Void> response = ((BrokerConfigManager)this.brokerConfigManager.get()).alterBrokerConfigs(clusterId, brokerId, request.getValue().toAlterConfigCommands());
        AsyncResponses.AsyncResponseBuilder.from(Response.status((Response.Status)Response.Status.NO_CONTENT)).entity(response).asyncResume(asyncResponse);
    }
}

