/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v2;

import io.confluent.kafkarest.controllers.ProduceController;
import io.confluent.kafkarest.controllers.RecordSerializer;
import io.confluent.kafkarest.controllers.SchemaManager;
import io.confluent.kafkarest.entities.EmbeddedFormat;
import io.confluent.kafkarest.entities.v2.ProduceRequest;
import io.confluent.kafkarest.entities.v2.ProduceResponse;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.resources.v2.AbstractProduceAction;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;

@Path(value="/topics/{topic}/partitions")
@Consumes(value={"application/vnd.kafka.binary.v2+json", "application/vnd.kafka.json.v2+json", "application/vnd.kafka.avro.v2+json", "application/vnd.kafka.jsonschema.v2+json", "application/vnd.kafka.protobuf.v2+json"})
@Produces(value={"application/vnd.kafka.v2+json"})
@ResourceAccesslistFeature.ResourceName(value="api.v2.produce-to-partition.*")
public final class ProduceToPartitionAction
extends AbstractProduceAction {
    @Inject
    public ProduceToPartitionAction(Provider<SchemaManager> schemaManager, Provider<RecordSerializer> recordSerializer, Provider<ProduceController> produceController) {
        super(schemaManager, recordSerializer, produceController);
    }

    @POST
    @Path(value="/{partition}")
    @PerformanceMetric(value="partition.produce-binary+v2")
    @Consumes(value={"application/vnd.kafka.binary.v2+json"})
    @ResourceAccesslistFeature.ResourceName(value="api.v2.produce-to-partition.binary")
    public void produceBinary(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topicName, @PathParam(value="partition") int partitionId, @Valid @NotNull ProduceRequest request) {
        CompletableFuture<ProduceResponse> response = this.produceWithoutSchema(EmbeddedFormat.BINARY, topicName, Optional.of(partitionId), request);
        AsyncResponses.AsyncResponseBuilder.from(Response.ok()).entity(response).status(ProduceResponse::getRequestStatus).asyncResume(asyncResponse);
    }

    @POST
    @Path(value="/{partition}")
    @PerformanceMetric(value="partition.produce-json+v2")
    @Consumes(value={"application/vnd.kafka.json.v2+json; qs=0.1"})
    @ResourceAccesslistFeature.ResourceName(value="api.v2.produce-to-partition.json")
    public void produceJson(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topicName, @PathParam(value="partition") int partitionId, @Valid @NotNull ProduceRequest request) {
        CompletableFuture<ProduceResponse> response = this.produceWithoutSchema(EmbeddedFormat.JSON, topicName, Optional.of(partitionId), request);
        AsyncResponses.AsyncResponseBuilder.from(Response.ok()).entity(response).status(ProduceResponse::getRequestStatus).asyncResume(asyncResponse);
    }

    @POST
    @Path(value="/{partition}")
    @PerformanceMetric(value="partition.produce-avro+v2")
    @Consumes(value={"application/vnd.kafka.avro.v2+json; qs=0.1"})
    @ResourceAccesslistFeature.ResourceName(value="api.v2.produce-to-partition.avro")
    public void produceAvro(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topicName, @PathParam(value="partition") int partitionId, @Valid @NotNull ProduceRequest request) {
        CompletableFuture<ProduceResponse> response = this.produceWithSchema(EmbeddedFormat.AVRO, topicName, Optional.of(partitionId), request);
        AsyncResponses.AsyncResponseBuilder.from(Response.ok()).entity(response).status(ProduceResponse::getRequestStatus).asyncResume(asyncResponse);
    }

    @POST
    @Path(value="/{partition}")
    @PerformanceMetric(value="partition.produce-jsonschema+v2")
    @Consumes(value={"application/vnd.kafka.jsonschema.v2+json; qs=0.1"})
    @ResourceAccesslistFeature.ResourceName(value="api.v2.produce-to-partition.json-schema")
    public void produceJsonSchema(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topicName, @PathParam(value="partition") int partitionId, @Valid @NotNull ProduceRequest request) {
        CompletableFuture<ProduceResponse> response = this.produceWithSchema(EmbeddedFormat.JSONSCHEMA, topicName, Optional.of(partitionId), request);
        AsyncResponses.AsyncResponseBuilder.from(Response.ok()).entity(response).status(ProduceResponse::getRequestStatus).asyncResume(asyncResponse);
    }

    @POST
    @Path(value="/{partition}")
    @PerformanceMetric(value="partition.produce-protobuf+v2")
    @Consumes(value={"application/vnd.kafka.protobuf.v2+json; qs=0.1"})
    @ResourceAccesslistFeature.ResourceName(value="api.v2.produce-to-partition.protobuf")
    public void produceProtobuf(@Suspended AsyncResponse asyncResponse, @PathParam(value="topic") String topicName, @PathParam(value="partition") int partitionId, @Valid @NotNull ProduceRequest request) {
        CompletableFuture<ProduceResponse> response = this.produceWithSchema(EmbeddedFormat.PROTOBUF, topicName, Optional.of(partitionId), request);
        AsyncResponses.AsyncResponseBuilder.from(Response.ok()).entity(response).status(ProduceResponse::getRequestStatus).asyncResume(asyncResponse);
    }
}

