/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources;

import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.resources.v2.V2ResourcesFeature;
import io.confluent.kafkarest.resources.v3.V3ResourcesFeature;
import java.util.Objects;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;

public final class ResourcesFeature
implements Feature {
    private final KafkaRestContext context;
    private final KafkaRestConfig config;

    public ResourcesFeature(KafkaRestContext context, KafkaRestConfig config) {
        this.context = Objects.requireNonNull(context);
        this.config = Objects.requireNonNull(config);
    }

    public boolean configure(FeatureContext configurable) {
        if (this.config.isV2ApiEnabled()) {
            configurable.register((Object)new V2ResourcesFeature(this.context));
        }
        if (this.config.isV3ApiEnabled()) {
            configurable.register(V3ResourcesFeature.class);
        }
        return true;
    }
}

