/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.v3.AutoValue_Resource_Metadata;
import io.confluent.kafkarest.entities.v3.AutoValue_Resource_Relationship;
import java.util.Optional;
import javax.annotation.Nullable;

public abstract class Resource {
    Resource() {
    }

    @JsonProperty(value="kind")
    public abstract String getKind();

    @JsonProperty(value="metadata")
    public abstract Metadata getMetadata();

    @AutoValue
    public static abstract class Relationship {
        Relationship() {
        }

        @JsonProperty(value="related")
        public abstract String getRelated();

        public static Relationship create(String related) {
            return new AutoValue_Resource_Relationship(related);
        }

        @JsonCreator
        static Relationship fromJson(@JsonProperty(value="related") String related) {
            return Relationship.create(related);
        }
    }

    @AutoValue
    public static abstract class Metadata {
        Metadata() {
        }

        @JsonProperty(value="self")
        public abstract String getSelf();

        @JsonProperty(value="resource_name")
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public abstract Optional<String> getResourceName();

        public static Builder builder() {
            return new AutoValue_Resource_Metadata.Builder();
        }

        @JsonCreator
        static Metadata fromJson(@JsonProperty(value="self") String self, @JsonProperty(value="resource_name") @Nullable String resourceName) {
            return Metadata.builder().setSelf(self).setResourceName(resourceName).build();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            Builder() {
            }

            public abstract Builder setSelf(String var1);

            public abstract Builder setResourceName(@Nullable String var1);

            public abstract Metadata build();
        }
    }

    public static abstract class Builder<BuilderT extends Builder<BuilderT>> {
        Builder() {
        }

        public abstract BuilderT setKind(String var1);

        public abstract BuilderT setMetadata(Metadata var1);
    }
}

