/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.ConsumerGroup;
import io.confluent.kafkarest.entities.v3.AutoValue_ConsumerGroupData;
import io.confluent.kafkarest.entities.v3.Resource;

@AutoValue
public abstract class ConsumerGroupData
extends Resource {
    ConsumerGroupData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="consumer_group_id")
    public abstract String getConsumerGroupId();

    @JsonProperty(value="is_simple")
    public abstract boolean isSimple();

    @JsonProperty(value="partition_assignor")
    public abstract String getPartitionAssignor();

    @JsonProperty(value="state")
    public abstract ConsumerGroup.State getState();

    @JsonProperty(value="coordinator")
    public abstract Resource.Relationship getCoordinator();

    @JsonProperty(value="consumers")
    public abstract Resource.Relationship getConsumers();

    @JsonProperty(value="lag_summary")
    public abstract Resource.Relationship getLagSummary();

    public static Builder builder() {
        return new AutoValue_ConsumerGroupData.Builder().setKind("KafkaConsumerGroup");
    }

    public static Builder fromConsumerGroup(ConsumerGroup consumerGroup) {
        return ConsumerGroupData.builder().setClusterId(consumerGroup.getClusterId()).setConsumerGroupId(consumerGroup.getConsumerGroupId()).setSimple(consumerGroup.isSimple()).setPartitionAssignor(consumerGroup.getPartitionAssignor()).setState(consumerGroup.getState());
    }

    @JsonCreator
    static ConsumerGroupData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="consumer_group_id") String consumerGroupId, @JsonProperty(value="is_simple") boolean isSimple, @JsonProperty(value="partition_assignor") String partitionAssignor, @JsonProperty(value="state") ConsumerGroup.State state, @JsonProperty(value="coordinator") Resource.Relationship coordinator, @JsonProperty(value="consumers") Resource.Relationship consumers, @JsonProperty(value="lag_summary") Resource.Relationship lagSummary) {
        return ((Builder)((Builder)ConsumerGroupData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setConsumerGroupId(consumerGroupId).setSimple(isSimple).setPartitionAssignor(partitionAssignor).setState(state).setCoordinator(coordinator).setConsumers(consumers).setLagSummary(lagSummary).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setConsumerGroupId(String var1);

        public abstract Builder setSimple(boolean var1);

        public abstract Builder setPartitionAssignor(String var1);

        public abstract Builder setState(ConsumerGroup.State var1);

        public abstract Builder setCoordinator(Resource.Relationship var1);

        public abstract Builder setConsumers(Resource.Relationship var1);

        public abstract Builder setLagSummary(Resource.Relationship var1);

        public abstract ConsumerGroupData build();
    }
}

