/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.Acl;
import io.confluent.kafkarest.entities.v3.AutoValue_AclData;
import io.confluent.kafkarest.entities.v3.Resource;

@AutoValue
public abstract class AclData
extends Resource {
    AclData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="resource_type")
    public abstract Acl.ResourceType getResourceType();

    @JsonProperty(value="resource_name")
    public abstract String getResourceName();

    @JsonProperty(value="pattern_type")
    public abstract Acl.PatternType getPatternType();

    @JsonProperty(value="principal")
    public abstract String getPrincipal();

    @JsonProperty(value="host")
    public abstract String getHost();

    @JsonProperty(value="operation")
    public abstract Acl.Operation getOperation();

    @JsonProperty(value="permission")
    public abstract Acl.Permission getPermission();

    public static Builder builder() {
        return new AutoValue_AclData.Builder().setKind("KafkaAcl");
    }

    public static Builder fromAcl(Acl acl) {
        return AclData.builder().setClusterId(acl.getClusterId()).setResourceType(acl.getResourceType()).setResourceName(acl.getResourceName()).setPatternType(acl.getPatternType()).setPrincipal(acl.getPrincipal()).setHost(acl.getHost()).setOperation(acl.getOperation()).setPermission(acl.getPermission());
    }

    @JsonCreator
    static AclData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="resource_type") Acl.ResourceType resourceType, @JsonProperty(value="resource_name") String resourceName, @JsonProperty(value="pattern_type") Acl.PatternType patternType, @JsonProperty(value="principal") String principal, @JsonProperty(value="host") String host, @JsonProperty(value="operation") Acl.Operation operation, @JsonProperty(value="permission") Acl.Permission permission) {
        return ((Builder)((Builder)AclData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setResourceType(resourceType).setResourceName(resourceName).setPatternType(patternType).setPrincipal(principal).setHost(host).setOperation(operation).setPermission(permission).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setResourceType(Acl.ResourceType var1);

        public abstract Builder setResourceName(String var1);

        public abstract Builder setPatternType(Acl.PatternType var1);

        public abstract Builder setPrincipal(String var1);

        public abstract Builder setHost(String var1);

        public abstract Builder setOperation(Acl.Operation var1);

        public abstract Builder setPermission(Acl.Permission var1);

        public abstract AclData build();
    }
}

