/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.protobuf.ByteString;
import io.confluent.kafkarest.entities.ConsumerRecord;
import io.confluent.kafkarest.entities.EntityUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.PositiveOrZero;

public final class BinaryConsumerRecord {
    @NotNull
    @Nullable
    private final String topic;
    @Nullable
    private final byte[] key;
    @Nullable
    private final byte[] value;
    @PositiveOrZero
    @Nullable
    private final Integer partition;
    @PositiveOrZero
    @Nullable
    private final Long offset;

    @JsonCreator
    private BinaryConsumerRecord(@JsonProperty(value="topic") @Nullable String topic, @JsonProperty(value="key") @Nullable byte[] key, @JsonProperty(value="value") @Nullable byte[] value, @JsonProperty(value="partition") @Nullable Integer partition, @JsonProperty(value="offset") @Nullable Long offset) {
        this.topic = topic;
        this.key = key;
        this.value = value;
        this.partition = partition;
        this.offset = offset;
    }

    @JsonProperty
    @Nullable
    public String getTopic() {
        return this.topic;
    }

    @JsonProperty
    @Nullable
    public String getKey() {
        return this.key != null ? EntityUtils.encodeBase64Binary(this.key) : null;
    }

    @JsonProperty
    @Nullable
    public String getValue() {
        return this.value != null ? EntityUtils.encodeBase64Binary(this.value) : null;
    }

    @JsonProperty
    @Nullable
    public Integer getPartition() {
        return this.partition;
    }

    @JsonProperty
    @Nullable
    public Long getOffset() {
        return this.offset;
    }

    public static BinaryConsumerRecord fromConsumerRecord(ConsumerRecord<ByteString, ByteString> record) {
        if (record.getPartition() < 0) {
            throw new IllegalArgumentException();
        }
        if (record.getOffset() < 0L) {
            throw new IllegalArgumentException();
        }
        return new BinaryConsumerRecord(Objects.requireNonNull(record.getTopic()), record.getKey() != null ? record.getKey().toByteArray() : null, record.getValue() != null ? record.getValue().toByteArray() : null, record.getPartition(), record.getOffset());
    }

    public ConsumerRecord<ByteString, ByteString> toConsumerRecord() {
        if (this.topic == null) {
            throw new IllegalStateException();
        }
        if (this.partition == null || this.partition < 0) {
            throw new IllegalStateException();
        }
        if (this.offset == null || this.offset < 0L) {
            throw new IllegalStateException();
        }
        return ConsumerRecord.create(this.topic, this.key != null ? ByteString.copyFrom((byte[])this.key) : null, this.value != null ? ByteString.copyFrom((byte[])this.value) : null, this.partition, this.offset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryConsumerRecord that = (BinaryConsumerRecord)o;
        return Objects.equals(this.topic, that.topic) && Arrays.equals(this.key, that.key) && Arrays.equals(this.value, that.value) && Objects.equals(this.partition, that.partition) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        int result = Objects.hash(this.topic, this.partition, this.offset);
        result = 31 * result + Arrays.hashCode(this.key);
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    public String toString() {
        return new StringJoiner(", ", BinaryConsumerRecord.class.getSimpleName() + "[", "]").add("topic='" + this.topic + "'").add("key=" + Arrays.toString(this.key)).add("value=" + Arrays.toString(this.value)).add("partition=" + this.partition).add("offset=" + this.offset).toString();
    }
}

