/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.AutoValue_ConsumerGroupLagSummary;
import java.util.Optional;

@AutoValue
public abstract class ConsumerGroupLagSummary {
    ConsumerGroupLagSummary() {
    }

    public abstract String getClusterId();

    public abstract String getConsumerGroupId();

    public abstract String getMaxLagClientId();

    public abstract String getMaxLagConsumerId();

    public abstract Optional<String> getMaxLagInstanceId();

    public abstract String getMaxLagTopicName();

    public abstract Integer getMaxLagPartitionId();

    public abstract Long getMaxLag();

    public abstract Long getTotalLag();

    public static Builder builder() {
        return new AutoValue_ConsumerGroupLagSummary.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        private long maxLag = -1L;
        private long totalLag = 0L;

        Builder() {
        }

        public final void addOffset(String topicName, String consumerId, Optional<String> instanceId, String clientId, int partitionId, long currentOffset, long endOffset) {
            long lag = Math.max(0L, endOffset - currentOffset);
            if (this.maxLag < lag) {
                this.maxLag = lag;
                this.setMaxLagConsumerId(consumerId);
                this.setMaxLagInstanceId(instanceId);
                this.setMaxLagClientId(clientId);
                this.setMaxLagTopicName(topicName);
                this.setMaxLagPartitionId(partitionId);
                this.setMaxLag(this.maxLag);
            }
            this.totalLag += lag;
            this.setTotalLag(this.totalLag);
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setConsumerGroupId(String var1);

        public abstract Builder setMaxLagClientId(String var1);

        public abstract Builder setMaxLagConsumerId(String var1);

        public abstract Builder setMaxLagInstanceId(Optional<String> var1);

        public abstract Builder setMaxLagTopicName(String var1);

        public abstract Builder setMaxLagPartitionId(Integer var1);

        public abstract Builder setMaxLag(Long var1);

        public abstract Builder setTotalLag(Long var1);

        public abstract ConsumerGroupLagSummary build();
    }
}

