/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.common;

import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.internals.KafkaFutureImpl;

public final class KafkaFutures {
    private KafkaFutures() {
    }

    public static <T> KafkaFuture<T> failedFuture(Throwable exception) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally(exception);
        return future;
    }

    public static <T> CompletableFuture<T> toCompletableFuture(KafkaFuture<T> kafkaFuture) {
        CompletableFuture completableFuture = new CompletableFuture();
        kafkaFuture.whenComplete((value, exception) -> {
            if (exception == null) {
                completableFuture.complete(value);
            } else {
                completableFuture.completeExceptionally((Throwable)exception);
            }
        });
        return completableFuture;
    }
}

