/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.jaxrs.base.JsonMappingExceptionMapper;
import com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.backends.BackendsModule;
import io.confluent.kafkarest.config.ConfigModule;
import io.confluent.kafkarest.controllers.ControllersModule;
import io.confluent.kafkarest.exceptions.ExceptionsModule;
import io.confluent.kafkarest.exceptions.KafkaRestExceptionMapper;
import io.confluent.kafkarest.extension.ContextInvocationHandler;
import io.confluent.kafkarest.extension.EnumConverterProvider;
import io.confluent.kafkarest.extension.InstantConverterProvider;
import io.confluent.kafkarest.extension.KafkaRestCleanupFilter;
import io.confluent.kafkarest.extension.KafkaRestContextProvider;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.extension.RestResourceExtension;
import io.confluent.kafkarest.resources.ResourcesFeature;
import io.confluent.kafkarest.response.ResponseModule;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.exceptions.ConstraintViolationExceptionMapper;
import io.confluent.rest.exceptions.WebApplicationExceptionMapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import javax.ws.rs.core.Configurable;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.StringUtil;

public class KafkaRestApplication
extends Application<KafkaRestConfig> {
    List<RestResourceExtension> restResourceExtensions;

    public KafkaRestApplication() {
        this(new Properties());
    }

    public KafkaRestApplication(Properties props) {
        this(new KafkaRestConfig(props));
    }

    public KafkaRestApplication(KafkaRestConfig config) {
        this(config, "");
    }

    public KafkaRestApplication(KafkaRestConfig config, String path) {
        super((RestConfig)config, path);
        this.restResourceExtensions = config.getConfiguredInstances("kafka.rest.resource.extension.class", RestResourceExtension.class);
    }

    public void configurePreResourceHandling(ServletContextHandler context) {
    }

    public void configurePostResourceHandling(ServletContextHandler context) {
    }

    public void setupResources(Configurable<?> config, KafkaRestConfig appConfig) {
        if (StringUtil.isBlank((String)appConfig.getString("bootstrap.servers")) && StringUtil.isBlank((String)appConfig.getString("zookeeper.connect"))) {
            throw new RuntimeException("Atleast one of bootstrap.servers or zookeeper.connect needs to be configured");
        }
        KafkaRestContextProvider.initialize(appConfig);
        ContextInvocationHandler contextInvocationHandler = new ContextInvocationHandler();
        KafkaRestContext context = (KafkaRestContext)Proxy.newProxyInstance(KafkaRestContext.class.getClassLoader(), new Class[]{KafkaRestContext.class}, (InvocationHandler)contextInvocationHandler);
        config.property("jersey.config.server.contentLength.buffer", (Object)0);
        config.register((Object)new BackendsModule());
        config.register((Object)new ConfigModule(appConfig));
        config.register((Object)new ControllersModule());
        config.register((Object)new ExceptionsModule());
        config.register((Object)new ResourcesFeature(context, appConfig));
        config.register((Object)new ResponseModule());
        config.register(ResourceAccesslistFeature.class);
        config.register(KafkaRestCleanupFilter.class);
        config.register(EnumConverterProvider.class);
        config.register(InstantConverterProvider.class);
        for (RestResourceExtension restResourceExtension : this.restResourceExtensions) {
            restResourceExtension.register(config, appConfig);
        }
    }

    public ObjectMapper getJsonMapper() {
        return super.getJsonMapper().registerModule((Module)new GuavaModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'")).setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    protected void registerExceptionMappers(Configurable<?> config, KafkaRestConfig restConfig) {
        config.register(JsonParseExceptionMapper.class);
        config.register(JsonMappingExceptionMapper.class);
        config.register(ConstraintViolationExceptionMapper.class);
        config.register((Object)new WebApplicationExceptionMapper((RestConfig)restConfig));
        config.register((Object)new KafkaRestExceptionMapper(restConfig));
    }

    public void onShutdown() {
        for (RestResourceExtension restResourceExtension : this.restResourceExtensions) {
            restResourceExtension.clean();
        }
        KafkaRestContextProvider.clean();
    }
}

