/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.protobuf;

import com.google.protobuf.Message;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.protobuf.MessageIndexes;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.rules.RulePhase;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializerConfig;
import io.confluent.kafka.serializers.schema.id.SchemaId;
import io.confluent.kafka.serializers.schema.id.SchemaIdSerializer;
import io.confluent.kafka.serializers.subject.strategy.ReferenceSubjectNameStrategy;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.header.Headers;

public abstract class AbstractKafkaProtobufSerializer<T extends Message>
extends AbstractKafkaSchemaSerDe {
    protected boolean normalizeSchema;
    protected boolean autoRegisterSchema;
    protected boolean propagateSchemaTags;
    protected boolean onlyLookupReferencesBySchema;
    protected int useSchemaId = -1;
    protected boolean idCompatStrict;
    protected boolean latestCompatStrict;
    protected String schemaFormat;
    protected boolean skipKnownTypes;
    protected ReferenceSubjectNameStrategy referenceSubjectNameStrategy;

    protected void configure(KafkaProtobufSerializerConfig config) {
        this.configureClientProperties(config, (SchemaProvider)new ProtobufSchemaProvider());
        this.normalizeSchema = config.normalizeSchema();
        this.autoRegisterSchema = config.autoRegisterSchema();
        this.propagateSchemaTags = config.propagateSchemaTags();
        this.onlyLookupReferencesBySchema = config.onlyLookupReferencesBySchema();
        this.useSchemaId = config.useSchemaId();
        this.idCompatStrict = config.getIdCompatibilityStrict();
        this.latestCompatStrict = config.getLatestCompatibilityStrict();
        this.schemaFormat = config.getSchemaFormat();
        this.skipKnownTypes = config.skipKnownTypes();
        this.referenceSubjectNameStrategy = config.referenceSubjectNameStrategyInstance();
    }

    protected KafkaProtobufSerializerConfig serializerConfig(Map<String, ?> props) {
        try {
            return new KafkaProtobufSerializerConfig(props);
        }
        catch (ConfigException e) {
            throw new ConfigException(e.getMessage());
        }
    }

    protected byte[] serializeImpl(String subject, String topic, boolean isKey, T object, ProtobufSchema schema) throws SerializationException, InvalidConfigurationException {
        return this.serializeImpl(subject, topic, isKey, null, object, schema);
    }

    protected byte[] serializeImpl(String subject, String topic, boolean isKey, Headers headers, T object, ProtobufSchema schema) throws SerializationException, InvalidConfigurationException {
        if (this.schemaRegistry == null) {
            throw new InvalidConfigurationException("SchemaRegistryClient not found. You need to configure the serializer or use serializer constructor with SchemaRegistryClient.");
        }
        if (object == null) {
            return null;
        }
        Object restClientErrorMsg = "";
        try {
            byte[] byArray;
            block26: {
                AbstractKafkaSchemaSerDe.ExtendedSchema extendedSchema;
                SchemaId schemaId;
                String formatted;
                boolean autoRegisterForDeps = this.autoRegisterSchema && !this.onlyLookupReferencesBySchema;
                boolean useLatestForDeps = this.useLatestVersion && !this.onlyLookupReferencesBySchema;
                schema = AbstractKafkaProtobufSerializer.resolveDependencies(this.schemaRegistry, this.normalizeSchema, autoRegisterForDeps, useLatestForDeps, this.latestCompatStrict, this.latestVersionsCache(), this.skipKnownTypes, this.referenceSubjectNameStrategy, topic, isKey, schema);
                if (this.autoRegisterSchema) {
                    Optional optSchema;
                    Schema s;
                    restClientErrorMsg = "Error registering Protobuf schema: ";
                    if (this.schemaFormat != null) {
                        formatted = schema.formattedString(this.schemaFormat);
                        schema = schema.copyWithSchema(formatted);
                    }
                    if ((s = this.registerWithResponse(subject, (ParsedSchema)schema, this.normalizeSchema, this.propagateSchemaTags)).getSchema() != null && (optSchema = this.schemaRegistry.parseSchema(s)).isPresent()) {
                        schema = (ProtobufSchema)optSchema.get();
                        schema = schema.copy(s.getVersion());
                    }
                    schemaId = new SchemaId("PROTOBUF", s.getId(), s.getGuid());
                } else if (this.useSchemaId >= 0) {
                    restClientErrorMsg = "Error retrieving schema ID";
                    if (this.schemaFormat != null) {
                        formatted = schema.formattedString(this.schemaFormat);
                        schema = schema.copyWithSchema(formatted);
                    }
                    schema = (ProtobufSchema)this.lookupSchemaBySubjectAndId(subject, this.useSchemaId, (ParsedSchema)schema, this.idCompatStrict);
                    Schema schemaEntity = new Schema(subject, null, Integer.valueOf(this.useSchemaId), (ParsedSchema)schema);
                    schemaId = new SchemaId("PROTOBUF", Integer.valueOf(this.useSchemaId), schemaEntity.getGuid());
                } else if (this.metadata != null) {
                    restClientErrorMsg = "Error retrieving latest with metadata '" + String.valueOf(this.metadata) + "'";
                    extendedSchema = this.getLatestWithMetadata(subject);
                    schema = (ProtobufSchema)extendedSchema.getSchema();
                    schemaId = new SchemaId("PROTOBUF", extendedSchema.getId(), extendedSchema.getGuid());
                } else if (this.useLatestVersion) {
                    restClientErrorMsg = "Error retrieving latest version: ";
                    extendedSchema = this.lookupLatestVersion(subject, (ParsedSchema)schema, this.latestCompatStrict);
                    schema = (ProtobufSchema)extendedSchema.getSchema();
                    schemaId = new SchemaId("PROTOBUF", extendedSchema.getId(), extendedSchema.getGuid());
                } else {
                    restClientErrorMsg = "Error retrieving Protobuf schema: ";
                    RegisterSchemaResponse response = this.schemaRegistry.getIdWithResponse(subject, (ParsedSchema)schema, this.normalizeSchema);
                    schemaId = new SchemaId("PROTOBUF", Integer.valueOf(response.getId()), response.getGuid());
                }
                object = (Message)this.executeRules(subject, topic, headers, RuleMode.WRITE, null, (ParsedSchema)schema, object);
                MessageIndexes indexes = schema.toMessageIndexes(object.getDescriptorForType().getFullName(), this.normalizeSchema);
                schemaId.setMessageIndexes(indexes.indexes());
                SchemaIdSerializer schemaIdSerializer = this.schemaIdSerializer(isKey);
                try {
                    byte[] payload = object.toByteArray();
                    payload = (byte[])this.executeRules(subject, topic, headers, payload, RulePhase.ENCODING, RuleMode.WRITE, null, (ParsedSchema)schema, payload);
                    byArray = schemaIdSerializer.serialize(topic, isKey, headers, payload, schemaId);
                    if (schemaIdSerializer == null) break block26;
                }
                catch (Throwable throwable) {
                    try {
                        if (schemaIdSerializer != null) {
                            try {
                                schemaIdSerializer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InterruptedIOException e) {
                        throw new TimeoutException("Error serializing Protobuf message", (Throwable)e);
                    }
                    catch (IOException | RuntimeException e) {
                        throw new SerializationException("Error serializing Protobuf message", (Throwable)e);
                    }
                    catch (RestClientException e) {
                        throw AbstractKafkaProtobufSerializer.toKafkaException((RestClientException)e, (String)((String)restClientErrorMsg + String.valueOf(schema)));
                    }
                }
                schemaIdSerializer.close();
            }
            return byArray;
        }
        finally {
            this.postOp(object);
        }
    }

    public static ProtobufSchema resolveDependencies(SchemaRegistryClient schemaRegistry, boolean autoRegisterSchema, boolean useLatestVersion, boolean latestCompatStrict, Map<AbstractKafkaSchemaSerDe.SubjectSchema, AbstractKafkaSchemaSerDe.ExtendedSchema> latestVersions, ReferenceSubjectNameStrategy strategy, String topic, boolean isKey, ProtobufSchema schema) throws IOException, RestClientException {
        return AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, autoRegisterSchema, useLatestVersion, latestCompatStrict, latestVersions, true, strategy, topic, isKey, schema);
    }

    public static ProtobufSchema resolveDependencies(SchemaRegistryClient schemaRegistry, boolean autoRegisterSchema, boolean useLatestVersion, boolean latestCompatStrict, Map<AbstractKafkaSchemaSerDe.SubjectSchema, AbstractKafkaSchemaSerDe.ExtendedSchema> latestVersions, boolean skipKnownTypes, ReferenceSubjectNameStrategy strategy, String topic, boolean isKey, ProtobufSchema schema) throws IOException, RestClientException {
        return AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, false, autoRegisterSchema, useLatestVersion, latestCompatStrict, latestVersions, skipKnownTypes, strategy, topic, isKey, schema);
    }

    public static ProtobufSchema resolveDependencies(SchemaRegistryClient schemaRegistry, boolean normalizeSchema, boolean autoRegisterSchema, boolean useLatestVersion, boolean latestCompatStrict, Map<AbstractKafkaSchemaSerDe.SubjectSchema, AbstractKafkaSchemaSerDe.ExtendedSchema> latestVersions, boolean skipKnownTypes, ReferenceSubjectNameStrategy strategy, String topic, boolean isKey, ProtobufSchema schema) throws IOException, RestClientException {
        return AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, normalizeSchema, autoRegisterSchema, false, useLatestVersion, latestCompatStrict, latestVersions, skipKnownTypes, strategy, topic, isKey, schema);
    }

    public static ProtobufSchema resolveDependencies(SchemaRegistryClient schemaRegistry, boolean normalizeSchema, boolean autoRegisterSchema, boolean propagateSchemaTags, boolean useLatestVersion, boolean latestCompatStrict, Map<AbstractKafkaSchemaSerDe.SubjectSchema, AbstractKafkaSchemaSerDe.ExtendedSchema> latestVersions, boolean skipKnownTypes, ReferenceSubjectNameStrategy strategy, String topic, boolean isKey, ProtobufSchema schema) throws IOException, RestClientException {
        if (schema.dependencies().isEmpty() || !schema.references().isEmpty()) {
            return schema;
        }
        HashMap<String, ProtoFileElement> dependencies = new HashMap<String, ProtoFileElement>(schema.dependencies());
        Schema s = AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, normalizeSchema, autoRegisterSchema, propagateSchemaTags, useLatestVersion, latestCompatStrict, latestVersions, skipKnownTypes, strategy, topic, isKey, null, schema.rawSchema(), dependencies);
        return schema.copy(s.getReferences(), dependencies);
    }

    private static Schema resolveDependencies(SchemaRegistryClient schemaRegistry, boolean normalizeSchema, boolean autoRegisterSchema, boolean propagateSchemaTags, boolean useLatestVersion, boolean latestCompatStrict, Map<AbstractKafkaSchemaSerDe.SubjectSchema, AbstractKafkaSchemaSerDe.ExtendedSchema> latestVersions, boolean skipKnownTypes, ReferenceSubjectNameStrategy strategy, String topic, boolean isKey, String name, ProtoFileElement protoFileElement, Map<String, ProtoFileElement> dependencies) throws IOException, RestClientException {
        String subject;
        Schema subschema;
        ArrayList<SchemaReference> references = new ArrayList<SchemaReference>();
        for (String dep : protoFileElement.getImports()) {
            if (skipKnownTypes && ProtobufSchema.knownTypes().contains(dep)) {
                dependencies.remove(dep);
                continue;
            }
            subschema = AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, normalizeSchema, autoRegisterSchema, propagateSchemaTags, useLatestVersion, latestCompatStrict, latestVersions, skipKnownTypes, strategy, topic, isKey, dep, dependencies.get(dep), dependencies);
            references.add(new SchemaReference(dep, subschema.getSubject(), subschema.getVersion()));
        }
        for (String dep : protoFileElement.getPublicImports()) {
            if (skipKnownTypes && ProtobufSchema.knownTypes().contains(dep)) {
                dependencies.remove(dep);
                continue;
            }
            subschema = AbstractKafkaProtobufSerializer.resolveDependencies(schemaRegistry, normalizeSchema, autoRegisterSchema, propagateSchemaTags, useLatestVersion, latestCompatStrict, latestVersions, skipKnownTypes, strategy, topic, isKey, dep, dependencies.get(dep), dependencies);
            references.add(new SchemaReference(dep, subschema.getSubject(), subschema.getVersion()));
        }
        ProtobufSchema schema = new ProtobufSchema(protoFileElement, references, dependencies);
        Integer id = null;
        Integer version = null;
        String string = subject = name != null ? strategy.subjectName(name, topic, isKey, (ParsedSchema)schema) : null;
        if (subject != null) {
            if (autoRegisterSchema) {
                Optional optSchema;
                RegisterSchemaResponse response = schemaRegistry.registerWithResponse(subject, (ParsedSchema)schema, normalizeSchema, propagateSchemaTags);
                if (response.getSchema() != null && (optSchema = schemaRegistry.parseSchema(new Schema(subject, response))).isPresent()) {
                    schema = (ProtobufSchema)optSchema.get();
                    schema = schema.copy(response.getVersion());
                }
                id = response.getId();
                version = schemaRegistry.getVersion(subject, (ParsedSchema)schema, normalizeSchema);
            } else if (useLatestVersion) {
                AbstractKafkaSchemaSerDe.ExtendedSchema extendedSchema = AbstractKafkaProtobufSerializer.lookupLatestVersion((SchemaRegistryClient)schemaRegistry, (String)subject, (ParsedSchema)schema, latestVersions, (boolean)latestCompatStrict);
                schema = (ProtobufSchema)extendedSchema.getSchema();
                id = extendedSchema.getId();
                version = extendedSchema.getVersion();
            } else {
                id = schemaRegistry.getId(subject, (ParsedSchema)schema, normalizeSchema);
                version = schemaRegistry.getVersion(subject, (ParsedSchema)schema, normalizeSchema);
            }
        }
        return new Schema(subject, version, id, (ParsedSchema)schema);
    }
}

