/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers.protobuf;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.DeserializerWithSchema;
import io.confluent.kafka.serializers.protobuf.AbstractKafkaProtobufDeserializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializerConfig;
import io.confluent.kafka.serializers.protobuf.ProtobufSchemaAndValue;
import java.io.IOException;
import java.util.Map;
import org.apache.kafka.common.header.Headers;

public class KafkaProtobufDeserializer<T extends Message>
extends AbstractKafkaProtobufDeserializer<T>
implements DeserializerWithSchema<T> {
    public KafkaProtobufDeserializer() {
    }

    public KafkaProtobufDeserializer(SchemaRegistryClient client) {
        this.schemaRegistry = client;
        this.ticker = this.ticker(client);
    }

    public KafkaProtobufDeserializer(SchemaRegistryClient client, Map<String, ?> props) {
        this(client, props, null);
    }

    @VisibleForTesting
    public KafkaProtobufDeserializer(SchemaRegistryClient client, Map<String, ?> props, Class<T> type) {
        this.schemaRegistry = client;
        this.ticker = this.ticker(client);
        this.configure(this.deserializerConfig(props), type);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.configure(new KafkaProtobufDeserializerConfig(configs), isKey);
    }

    protected void configure(KafkaProtobufDeserializerConfig config, boolean isKey) {
        this.isKey = isKey;
        if (isKey) {
            this.configure(config, config.getClass("specific.protobuf.key.type"));
        } else {
            this.configure(config, config.getClass("specific.protobuf.value.type"));
        }
    }

    public T deserialize(String topic, byte[] bytes) {
        return this.deserialize(topic, null, bytes);
    }

    public T deserialize(String topic, Headers headers, byte[] bytes) {
        return (T)((Message)this.deserialize(false, topic, this.isKey, headers, bytes));
    }

    public ProtobufSchemaAndValue deserializeWithSchema(String topic, Headers headers, byte[] bytes) {
        return this.deserializeWithSchemaAndVersion(topic, this.isKey, headers, bytes);
    }

    public void close() {
        try {
            super.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while closing deserializer", e);
        }
    }
}

